/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;

public class StatementColumnPermission
extends StatementTablePermission {
    private FormatableBitSet columns;

    public StatementColumnPermission(UUID uUID, int n, FormatableBitSet formatableBitSet) {
        super(uUID, n);
        this.columns = formatableBitSet;
    }

    public FormatableBitSet getColumns() {
        return this.columns;
    }

    public boolean equals(Object object) {
        if (object instanceof StatementColumnPermission) {
            StatementColumnPermission statementColumnPermission = (StatementColumnPermission)object;
            if (!this.columns.equals(statementColumnPermission.columns)) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    public void check(LanguageConnectionContext languageConnectionContext, String string, boolean bl, Activation activation) throws StandardException {
        int n;
        Object object;
        Object object2;
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        if (this.hasPermissionOnTable(languageConnectionContext, activation, string, bl, execPreparedStatement)) {
            return;
        }
        FormatableBitSet formatableBitSet = null;
        if (!bl) {
            formatableBitSet = this.addPermittedColumns(dataDictionary, false, "PUBLIC", formatableBitSet);
            formatableBitSet = this.addPermittedColumns(dataDictionary, false, string, formatableBitSet);
        }
        formatableBitSet = this.addPermittedColumns(dataDictionary, true, "PUBLIC", formatableBitSet);
        formatableBitSet = this.addPermittedColumns(dataDictionary, true, string, formatableBitSet);
        FormatableBitSet formatableBitSet2 = (FormatableBitSet)this.columns.clone();
        int n2 = formatableBitSet2.anySetBit();
        while (n2 >= 0) {
            if (formatableBitSet != null && formatableBitSet.get(n2)) {
                formatableBitSet2.clear(n2);
            }
            n2 = formatableBitSet2.anySetBit(n2);
        }
        if (formatableBitSet2.anySetBit() < 0) {
            return;
        }
        String string2 = languageConnectionContext.getCurrentRoleId(activation);
        RoleGrantDescriptor roleGrantDescriptor = null;
        if (string2 != null) {
            String string3 = dataDictionary.getAuthorizationDatabaseOwner();
            roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string2, string, string3);
            if (roleGrantDescriptor == null) {
                roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string2, "PUBLIC", string3);
            }
            if (roleGrantDescriptor == null) {
                languageConnectionContext.setCurrentRole(activation, null);
            } else {
                object2 = dataDictionary.createRoleClosureIterator(activation.getTransactionController(), string2, true);
                while (formatableBitSet2.anySetBit() >= 0 && (object = object2.next()) != null) {
                    formatableBitSet2 = this.tryRole(languageConnectionContext, dataDictionary, bl, (String)object, formatableBitSet2);
                }
            }
        }
        if ((n = formatableBitSet2.anySetBit()) >= 0) {
            object2 = this.getTableDescriptor(dataDictionary);
            object = ((TableDescriptor)object2).getColumnDescriptor(n + 1);
            if (object == null) {
                throw StandardException.newException("4250E", "column");
            }
            throw StandardException.newException(bl ? "42503" : "42502", string, (Object)this.getPrivName(), (Object)((ColumnDescriptor)object).getColumnName(), (Object)((TableDescriptor)object2).getSchemaName(), (Object)((TableDescriptor)object2).getName());
        }
        object2 = dataDictionary.getDependencyManager();
        object = dataDictionary.getRoleDefinitionDescriptor(string2);
        ContextManager contextManager = languageConnectionContext.getContextManager();
        object2.addDependency(execPreparedStatement, (Provider)object, contextManager);
        object2.addDependency(activation, (Provider)object, contextManager);
    }

    private FormatableBitSet addPermittedColumns(DataDictionary dataDictionary, boolean bl, String string, FormatableBitSet formatableBitSet) throws StandardException {
        if (formatableBitSet != null && formatableBitSet.getNumBitsSet() == formatableBitSet.size()) {
            return formatableBitSet;
        }
        ColPermsDescriptor colPermsDescriptor = dataDictionary.getColumnPermissions(this.tableUUID, this.privType, false, string);
        if (colPermsDescriptor != null) {
            if (formatableBitSet == null) {
                return colPermsDescriptor.getColumns();
            }
            formatableBitSet.or(colPermsDescriptor.getColumns());
        }
        return formatableBitSet;
    }

    public PermissionsDescriptor getPermissionDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        if (this.oneAuthHasPermissionOnTable(dataDictionary, string, false)) {
            return dataDictionary.getTablePermissions(this.tableUUID, string);
        }
        if (this.oneAuthHasPermissionOnTable(dataDictionary, "PUBLIC", false)) {
            return dataDictionary.getTablePermissions(this.tableUUID, "PUBLIC");
        }
        ColPermsDescriptor colPermsDescriptor = dataDictionary.getColumnPermissions(this.tableUUID, this.privType, false, string);
        if (colPermsDescriptor != null && colPermsDescriptor.getColumns() != null) {
            FormatableBitSet formatableBitSet = colPermsDescriptor.getColumns();
            int n = this.columns.anySetBit();
            while (n >= 0) {
                if (formatableBitSet.get(n)) {
                    return colPermsDescriptor;
                }
                n = this.columns.anySetBit(n);
            }
        }
        return null;
    }

    public PermissionsDescriptor getPUBLIClevelColPermsDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        ColPermsDescriptor colPermsDescriptor = dataDictionary.getColumnPermissions(this.tableUUID, this.privType, false, string);
        FormatableBitSet formatableBitSet = colPermsDescriptor.getColumns();
        boolean bl = true;
        int n = this.columns.anySetBit();
        while (n >= 0 && bl) {
            if (!formatableBitSet.get(n)) {
                bl = false;
            }
            n = this.columns.anySetBit(n);
        }
        if (bl) {
            return null;
        }
        return dataDictionary.getColumnPermissions(this.tableUUID, this.privType, false, "PUBLIC");
    }

    public boolean allColumnsCoveredByUserOrPUBLIC(String string, DataDictionary dataDictionary) throws StandardException {
        int n;
        ColPermsDescriptor colPermsDescriptor = dataDictionary.getColumnPermissions(this.tableUUID, this.privType, false, string);
        FormatableBitSet formatableBitSet = colPermsDescriptor.getColumns();
        FormatableBitSet formatableBitSet2 = (FormatableBitSet)this.columns.clone();
        boolean bl = true;
        if (formatableBitSet != null) {
            n = formatableBitSet2.anySetBit();
            while (n >= 0) {
                if (formatableBitSet.get(n)) {
                    formatableBitSet2.clear(n);
                }
                n = formatableBitSet2.anySetBit(n);
            }
        }
        if (formatableBitSet2.anySetBit() >= 0) {
            colPermsDescriptor = dataDictionary.getColumnPermissions(this.tableUUID, this.privType, false, "PUBLIC");
            formatableBitSet = colPermsDescriptor.getColumns();
            if (formatableBitSet != null) {
                n = formatableBitSet2.anySetBit();
                while (n >= 0) {
                    if (formatableBitSet.get(n)) {
                        formatableBitSet2.clear(n);
                    }
                    n = formatableBitSet2.anySetBit(n);
                }
            }
            if (formatableBitSet2.anySetBit() >= 0) {
                bl = false;
            }
        }
        return bl;
    }

    private FormatableBitSet tryRole(LanguageConnectionContext languageConnectionContext, DataDictionary dataDictionary, boolean bl, String string, FormatableBitSet formatableBitSet) throws StandardException {
        FormatableBitSet formatableBitSet2 = null;
        if (!bl) {
            formatableBitSet2 = this.addPermittedColumns(dataDictionary, false, string, null);
        }
        formatableBitSet2 = this.addPermittedColumns(dataDictionary, true, string, formatableBitSet2);
        int n = formatableBitSet.anySetBit();
        while (n >= 0) {
            if (formatableBitSet2 != null && formatableBitSet2.get(n)) {
                formatableBitSet.clear(n);
            }
            n = formatableBitSet.anySetBit(n);
        }
        return formatableBitSet;
    }

    public String toString() {
        return "StatementColumnPermission: " + this.getPrivName() + " " + this.tableUUID + " columns: " + this.columns;
    }
}

