/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.util.Map;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.exceptions.ForbiddenStateException;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.manager.BeanManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentStructures {
    private DeploymentStructures() {
    }

    public static BeanDeployment getOrCreateBeanDeployment(Deployment deployment, BeanManagerImpl deploymentManager, Map<BeanDeploymentArchive, BeanDeployment> beanDeployments, Class<?> clazz) {
        BeanDeploymentArchive beanDeploymentArchive = deployment.loadBeanDeploymentArchive(clazz);
        if (beanDeploymentArchive == null) {
            throw new ForbiddenStateException(UtilMessage.UNABLE_TO_FIND_BEAN_DEPLOYMENT_ARCHIVE, clazz);
        }
        if (beanDeployments.containsKey(beanDeploymentArchive)) {
            return beanDeployments.get(beanDeploymentArchive);
        }
        BeanDeployment beanDeployment = new BeanDeployment(beanDeploymentArchive, deploymentManager, deployment.getServices());
        beanDeployments.put(beanDeploymentArchive, beanDeployment);
        return beanDeployment;
    }
}

