/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;

public final class ContainerTransaction
extends Descriptor {
    private String transactionAttribute;
    public static final String NOT_SUPPORTED = "NotSupported";
    public static final String SUPPORTS = "Supports";
    public static final String REQUIRED = "Required";
    public static final String REQUIRES_NEW = "RequiresNew";
    public static final String MANDATORY = "Mandatory";
    public static final String NEVER = "Never";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ContainerTransaction.class);

    public ContainerTransaction(ContainerTransaction other) {
        if (other != null) {
            this.transactionAttribute = other.transactionAttribute;
            this.setDescription(other.getDescription());
        }
    }

    public ContainerTransaction(String transactionAttribute, String description) {
        super("a Container Transaction", description);
        boolean isValidAttribute;
        boolean bl = isValidAttribute = NOT_SUPPORTED.equals(transactionAttribute) || SUPPORTS.equals(transactionAttribute) || REQUIRED.equals(transactionAttribute) || REQUIRED.equals(transactionAttribute) || REQUIRES_NEW.equals(transactionAttribute) || MANDATORY.equals(transactionAttribute) || NEVER.equals(transactionAttribute);
        if (!isValidAttribute) {
            if (this.isBoundsChecking()) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionunknowncontainertxtype", "Unknown ContainerTransaction type: {0}", new Object[]{transactionAttribute}));
            }
        }
        this.transactionAttribute = transactionAttribute;
    }

    public String getTransactionAttribute() {
        return this.transactionAttribute;
    }

    public boolean equals(Object other) {
        ContainerTransaction otherContainerTransaction;
        return other != null && other instanceof ContainerTransaction && (otherContainerTransaction = (ContainerTransaction)other).getTransactionAttribute().equals(this.getTransactionAttribute());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getTransactionAttribute().hashCode();
        return result;
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Container Transaction: ").append(this.getTransactionAttribute()).append("@").append(this.getDescription());
    }
}

