/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dynamic;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClassWriter {
    protected Class<?> parentClass;
    protected String parentClassName;
    protected static final String INIT = "<init>";
    private static final String WRITE_REPLACE = "writeReplace";

    public DynamicClassWriter() {
        this(DynamicEntityImpl.class);
    }

    public DynamicClassWriter(Class<?> parentClass) {
        this.parentClass = parentClass;
    }

    public DynamicClassWriter(String parentClassName) {
        if (parentClassName == null || parentClassName.length() == 0) {
            throw DynamicException.illegalParentClassName(parentClassName);
        }
        this.parentClassName = parentClassName;
    }

    public Class<?> getParentClass() {
        return this.parentClass;
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public byte[] writeClass(DynamicClassLoader loader, String className) throws ClassNotFoundException {
        Class<?> parent;
        if (this.parentClass == null && this.parentClassName != null) {
            this.parentClass = loader.loadClass(this.parentClassName);
        }
        if ((parent = this.getParentClass()) == null || parent.isPrimitive() || parent.isArray() || parent.isEnum() || parent.isInterface() || Modifier.isFinal(parent.getModifiers())) {
            throw new IllegalArgumentException("Invalid parent class: " + parent);
        }
        ClassWriter cw = new ClassWriter(true);
        cw.visit(49, 33, className.replace('.', '/'), Type.getType(parent).getInternalName(), this.getInterfaces(), null);
        this.addFields(cw);
        this.addConstructors(cw);
        this.addMethods(cw);
        this.addWriteReplace(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected String[] getInterfaces() {
        return null;
    }

    protected void addConstructors(ClassWriter cw) {
        Constructor<?>[] constructors = this.getParentClass().getDeclaredConstructors();
        for (int index = 0; index < constructors.length; ++index) {
            if (!Modifier.isPublic(constructors[index].getModifiers()) && !Modifier.isProtected(constructors[index].getModifiers())) continue;
            this.addConstructor(cw, constructors[index]);
        }
    }

    protected void addConstructor(ClassWriter cw, Constructor<?> constructor) {
        Type[] types = new Type[constructor.getParameterTypes().length];
        for (int index = 0; index < constructor.getParameterTypes().length; ++index) {
            types[index] = Type.getType(constructor.getParameterTypes()[index]);
        }
        String consDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])types);
        CodeVisitor mv = cw.visitMethod(1, INIT, consDesc, null, null);
        mv.visitVarInsn(25, 0);
        for (int param = 1; param <= constructor.getParameterTypes().length; ++param) {
            mv.visitVarInsn(25, param);
        }
        mv.visitMethodInsn(183, Type.getType(constructor.getDeclaringClass()).getInternalName(), INIT, consDesc);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    protected void addWriteReplace(ClassWriter cw) {
        boolean parentHasWriteReplace = false;
        try {
            this.getParentClass().getDeclaredMethod(WRITE_REPLACE, new Class[0]);
            parentHasWriteReplace = true;
        }
        catch (NoSuchMethodException e) {
            parentHasWriteReplace = false;
        }
        if (Serializable.class.isAssignableFrom(this.getParentClass()) && parentHasWriteReplace) {
            Method method;
            try {
                method = this.getParentClass().getDeclaredMethod(WRITE_REPLACE, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            String methodDesc = Type.getMethodDescriptor((Method)method);
            String[] exceptionsDesc = new String[]{Type.getType(ObjectStreamException.class).getInternalName()};
            CodeVisitor mv = cw.visitMethod(4, method.getName(), methodDesc, exceptionsDesc, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, Type.getInternalName(this.getParentClass()), method.getName(), methodDesc);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
        }
    }

    protected void addFields(ClassWriter cw) {
    }

    protected void addMethods(ClassWriter cw) {
    }

    protected DynamicClassWriter createCopy(Class<?> parentClass) {
        return new DynamicClassWriter(parentClass);
    }

    protected boolean isCompatible(DynamicClassWriter writer) {
        if (writer == null) {
            return false;
        }
        if (this.getClass() != writer.getClass()) {
            return false;
        }
        if (this.getParentClass() == null) {
            return this.getParentClassName() != null && this.getParentClassName().equals(writer.getParentClassName());
        }
        return this.getParentClass() == writer.getParentClass();
    }

    public String toString() {
        String parentName = this.getParentClass() == null ? this.getParentClassName() : this.getParentClass().getName();
        return Helper.getShortClassName(this.getClass()) + "(" + parentName + ")";
    }
}

