/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.SystemEnvironment;
import java.io.File;

class SolarisSystemEnvironment
extends SystemEnvironment {
    SolarisSystemEnvironment() {
        this.setHostId(this.getCommandOutput("/usr/bin/hostid"));
        this.setSystemModel(this.getCommandOutput("/usr/bin/uname", "-i"));
        this.setSystemManufacturer(this.getSolarisSystemManufacturer());
        this.setCpuManufacturer(this.getSolarisCpuManufacturer());
        this.setSerialNumber(this.getSolarisSN());
    }

    private String getSolarisCpuManufacturer() {
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            return "Sun Microsystems, Inc";
        }
        return this.getSmbiosData("3", "Manufacturer: ");
    }

    private String getSolarisSystemManufacturer() {
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            return "Sun Microsystems, Inc";
        }
        return this.getSmbiosData("1", "Manufacturer: ");
    }

    private String getSolarisSN() {
        String tmp = this.getFileContent("/var/run/psn");
        if (tmp.length() > 0) {
            return tmp.trim();
        }
        String tmpSN = this.getSneepSN();
        if (tmpSN.length() > 0) {
            return tmpSN;
        }
        tmpSN = this.getSmbiosData("1", "Serial Number: ");
        if (tmpSN.length() > 0) {
            return tmpSN;
        }
        tmpSN = this.getSmbiosData("3", "Serial Number: ");
        if (tmpSN.length() > 0) {
            return tmpSN;
        }
        return "";
    }

    private String getSmbiosData(String type, String target) {
        String output = this.getCommandOutput("/usr/sbin/smbios", "-t", type);
        for (String s : output.split("\n")) {
            String tmp;
            String lowerCaseStr;
            int indx;
            if (!s.contains(target) || (indx = s.indexOf(target) + target.length()) >= s.length() || (lowerCaseStr = (tmp = s.substring(indx).trim()).toLowerCase()).startsWith("not available") || lowerCaseStr.startsWith("to be filled by o.e.m")) continue;
            return tmp;
        }
        return "";
    }

    private String getSneepSN() {
        String basedir = this.getCommandOutput("pkgparam", "SUNWsneep", "BASEDIR");
        File f = new File(basedir + "/bin/sneep");
        if (f.exists()) {
            String sneepSN = this.getCommandOutput(basedir + "/bin/sneep");
            if (sneepSN.equalsIgnoreCase("unknown")) {
                return "";
            }
            return sneepSN;
        }
        return "";
    }
}

