/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.xml;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.flashlight.xml.Probe;
import org.glassfish.flashlight.xml.ProbeParam;
import org.glassfish.flashlight.xml.Provider;
import org.glassfish.flashlight.xml.XmlConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeProviderXMLParser {
    private List<Provider> providers = new ArrayList<Provider>();
    private Document document;
    private static final Logger logger = LogDomains.getLogger(ProbeProviderXMLParser.class, (String)"javax.enterprise.system.tools.monitor");
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ProbeProviderXMLParser.class);

    public ProbeProviderXMLParser(InputStream is) throws Exception {
        this.initProperties(is);
        this.generateProviders();
        if (this.providers.size() == 0) {
            String errStr = localStrings.getLocalString("noProviderFromXML", "No providers identified from the xml");
            logger.log(Level.SEVERE, errStr);
        }
    }

    private void initProperties(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMParser parser = new DOMParser();
            InputSource isource = new InputSource(is);
            parser.parse(isource);
            this.document = parser.getDocument();
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            throw new Exception(x.getLocalizedMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new Exception(pce.getLocalizedMessage());
        }
        catch (IOException ioe) {
            throw new Exception(ioe.getLocalizedMessage());
        }
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    private void generateProviders() throws Exception {
        Element probeProvidersElement;
        NodeList probeProviderList;
        if (this.document != null && (probeProviderList = (probeProvidersElement = this.document.getDocumentElement()).getElementsByTagName(XmlConstants.PROBE_PROVIDER)) != null && probeProviderList.getLength() > 0) {
            for (int i = 0; i < probeProviderList.getLength(); ++i) {
                Element probeProvider = (Element)probeProviderList.item(i);
                Provider p = this.getProvider(probeProvider);
                this.providers.add(p);
            }
        }
    }

    private Provider getProvider(Element providerEl) throws Exception {
        ArrayList<Probe> probes = new ArrayList<Probe>();
        String moduleProviderName = providerEl.getAttribute(XmlConstants.MODULE_PROVIDER_NAME);
        String moduleName = providerEl.getAttribute(XmlConstants.MODULE_NAME);
        String probeProviderName = providerEl.getAttribute(XmlConstants.PROBE_PROVIDER_NAME);
        String providerClass = providerEl.getAttribute(XmlConstants.PROBE_PROVIDER_CLASS);
        NodeList probeList = providerEl.getElementsByTagName(XmlConstants.PROBE);
        if (probeList != null && probeList.getLength() > 0) {
            for (int i = 0; i < probeList.getLength(); ++i) {
                Element probeEl = (Element)probeList.item(i);
                Probe p = this.getProbe(probeEl);
                probes.add(p);
            }
        }
        return new Provider(moduleProviderName, moduleName, probeProviderName, providerClass, probes);
    }

    private Probe getProbe(Element probeEl) throws Exception {
        String hidden;
        String name = probeEl.getAttribute(XmlConstants.PROBE_NAME);
        String self = probeEl.getAttribute(XmlConstants.PROBE_SELF);
        if (self == null) {
            self = "false";
        }
        if ((hidden = probeEl.getAttribute(XmlConstants.PROBE_HIDDEN)) == null) {
            hidden = "false";
        }
        String method = probeEl.getElementsByTagName(XmlConstants.METHOD).item(0).getFirstChild().getNodeValue();
        ArrayList<ProbeParam> params = new ArrayList<ProbeParam>();
        NodeList probeParamsList = probeEl.getElementsByTagName(XmlConstants.PROBE_PARAM);
        if (probeParamsList != null && probeParamsList.getLength() > 0) {
            for (int i = 0; i < probeParamsList.getLength(); ++i) {
                Element probeParamEl = (Element)probeParamsList.item(i);
                ProbeParam probeParam = this.getProbeParam(probeParamEl);
                params.add(probeParam);
            }
        }
        Probe probe = new Probe(name, method, params, Boolean.parseBoolean(self), Boolean.parseBoolean(hidden));
        return probe;
    }

    private ProbeParam getProbeParam(Element paramEl) throws Exception {
        String name = paramEl.getAttribute(XmlConstants.PROBE_PARAM_NAME);
        String type = paramEl.getAttribute(XmlConstants.PROBE_PARAM_TYPE);
        return new ProbeParam(name, type);
    }
}

