/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebFragmentDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsoluteOrderingDescriptor
extends Descriptor {
    private static final Object OTHERS = new Object();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbsoluteOrderingDescriptor.class);
    private List absOrder = new ArrayList();
    private boolean hasOthers;

    public void addName(String name) {
        if (!this.absOrder.add(name)) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.exceptionalreadydefinedinabsoluteordering", "[{0}] has already been defined in the absolute-ordering.", new Object[]{name}));
        }
    }

    public void addOthers() {
        if (!this.absOrder.add(OTHERS)) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.exceptionalreadydefinedinabsoluteordering", "[{0}] is already defined in the absolute-ordering.", new Object[]{"others"}));
        }
        this.hasOthers = true;
    }

    public List getOrdering() {
        return Collections.unmodifiableList(this.absOrder);
    }

    public boolean hasOthers() {
        return this.hasOthers;
    }

    public List<WebFragmentDescriptor> order(List<WebFragmentDescriptor> wfs) {
        ArrayList<WebFragmentDescriptor> wfList = new ArrayList<WebFragmentDescriptor>();
        if (wfs != null && wfs.size() > 0) {
            HashMap<String, WebFragmentDescriptor> map = new HashMap<String, WebFragmentDescriptor>();
            ArrayList<WebFragmentDescriptor> othersList = new ArrayList<WebFragmentDescriptor>();
            for (WebFragmentDescriptor wf : wfs) {
                String name = wf.getName();
                if (name != null && name.length() > 0 && this.absOrder.contains(name)) {
                    map.put(name, wf);
                    continue;
                }
                othersList.add(wf);
            }
            for (WebFragmentDescriptor obj : this.absOrder) {
                if (obj instanceof String) {
                    WebFragmentDescriptor wf = (WebFragmentDescriptor)map.get((String)((Object)obj));
                    if (wf != null) {
                        wfList.add(wf);
                        continue;
                    }
                    throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.exceptionnamenotdefinedinordering", "The name [{0}] in ordering is not defined.", new Object[]{obj}));
                }
                for (WebFragmentDescriptor wf : othersList) {
                    wfList.add(wf);
                }
            }
        }
        return wfList;
    }

    private WebFragmentDescriptor getWebFragmentDescriptor(List<WebFragmentDescriptor> wfs, String name) {
        WebFragmentDescriptor webFragment = null;
        if (name != null) {
            for (WebFragmentDescriptor wf : wfs) {
                String wfName = wf.getName();
                if (!name.equals(wfName)) continue;
                webFragment = wf;
                break;
            }
        }
        return webFragment;
    }
}

