/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.inject.spi.Decorator;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeBeanResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeDecoratorResolver
extends TypeSafeBeanResolver<Decorator<?>> {
    public TypeSafeDecoratorResolver(BeanManagerImpl manager, Iterable<Decorator<?>> decorators) {
        super(manager, decorators);
    }

    @Override
    protected boolean matches(Resolvable resolvable, Decorator<?> bean) {
        return Reflections.matches(Collections.singleton(bean.getDelegateType()), resolvable.getTypes()) && Beans.containsAllBindings(bean.getDelegateQualifiers(), resolvable.getQualifiers(), this.getBeanManager()) && this.getBeanManager().getEnabledDecoratorClasses().contains(bean.getBeanClass());
    }

    @Override
    protected Set<Decorator<?>> sortResult(Set<Decorator<?>> matchedDecorators) {
        TreeSet sortedBeans = new TreeSet(new Comparator<Decorator<?>>(){

            @Override
            public int compare(Decorator<?> o1, Decorator<?> o2) {
                List<Class<?>> enabledDecorators = TypeSafeDecoratorResolver.this.getBeanManager().getEnabledDecoratorClasses();
                int p1 = enabledDecorators.indexOf(o1.getBeanClass());
                int p2 = enabledDecorators.indexOf(o2.getBeanClass());
                return p1 - p2;
            }
        });
        sortedBeans.addAll(matchedDecorators);
        return sortedBeans;
    }
}

