/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;

final class IndexHtmlTokens {
    public static final String VERSION_TOKEN_NAME = "VERSION";
    public static final String DOMAIN_NAME_TOKEN_NAME = "DOMAIN_NAME";
    public static final String INSTALL_ROOT_TOKEN_NAME = "INSTALL_ROOT";
    public static final String INSTALL_ROOT_DEFAULT_VALUE = "INSTALL_ROOT";

    private IndexHtmlTokens() {
    }

    static final TokenValueSet getTokenValueSet(DomainConfig dc) {
        PEFileLayout lo = new PEFileLayout(dc);
        TokenValueSet tokens = new TokenValueSet();
        tokens.add(IndexHtmlTokens.getInstallRoot(lo));
        tokens.add(IndexHtmlTokens.getVersion());
        tokens.add(IndexHtmlTokens.getDomainName(dc));
        return tokens;
    }

    private static TokenValue getInstallRoot(PEFileLayout lo) {
        String ir;
        try {
            ir = lo.getInstallRootDir().getAbsolutePath();
        }
        catch (Exception e) {
            ir = "INSTALL_ROOT";
        }
        TokenValue tv = new TokenValue("INSTALL_ROOT", ir);
        return tv;
    }

    private static TokenValue getVersion() {
        String version = Version.getFullVersion();
        TokenValue tv = new TokenValue(VERSION_TOKEN_NAME, version);
        return tv;
    }

    private static TokenValue getDomainName(DomainConfig dc) {
        String dn = dc.getDomainName();
        TokenValue tv = new TokenValue(DOMAIN_NAME_TOKEN_NAME, dn);
        return tv;
    }
}

