/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import org.eclipse.persistence.annotations.CollectionTable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;

public class BasicCollectionAccessor
extends DirectCollectionAccessor {
    private ColumnMetadata m_valueColumn;

    public BasicCollectionAccessor() {
        super("<basic-collection>");
    }

    protected BasicCollectionAccessor(String xmlElement) {
        super(xmlElement);
    }

    public BasicCollectionAccessor(MetadataAnnotation basicCollection, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(basicCollection, accessibleObject, classAccessor);
        if (basicCollection != null) {
            this.m_valueColumn = new ColumnMetadata((MetadataAnnotation)basicCollection.getAttribute("valueColumn"), accessibleObject);
        }
        if (this.isAnnotationPresent(CollectionTable.class)) {
            this.setCollectionTable(new CollectionTableMetadata(this.getAnnotation(CollectionTable.class), accessibleObject, false));
        }
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_value_column")) {
            return this.m_valueColumn == null ? super.getColumn(loggingCtx) : this.m_valueColumn;
        }
        return super.getColumn(loggingCtx);
    }

    protected String getDefaultCollectionTableName() {
        if (this.m_valueColumn != null && this.m_valueColumn.getTable() != null && !this.m_valueColumn.getTable().equals("")) {
            return this.m_valueColumn.getTable();
        }
        return super.getDefaultCollectionTableName();
    }

    protected String getKeyConverter() {
        return null;
    }

    public ColumnMetadata getValueColumn() {
        return this.m_valueColumn;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_valueColumn, accessibleObject);
    }

    public boolean isBasicCollection() {
        return true;
    }

    public void process() {
        if (!this.isValidDirectCollectionType()) {
            throw ValidationException.invalidTypeForBasicCollectionAttribute((String)this.getAttributeName(), (Object)this.getRawClass(), (Object)this.getJavaClass());
        }
        this.processDirectCollectionMapping();
    }

    protected void processCollectionTable(CollectionMapping mapping) {
        super.processCollectionTable(mapping);
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn : this.processPrimaryKeyJoinColumns(new PrimaryKeyJoinColumnsMetadata(this.getCollectionTable().getPrimaryKeyJoinColumns()))) {
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            this.setFieldName(pkField, this.getOwningDescriptor().getPrimaryKeyFieldName(), "metadata_default_pk_column");
            pkField.setTable(this.getDescriptor().getPrimaryTable());
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            this.setFieldName(fkField, this.getOwningDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column");
            fkField.setTable(this.getReferenceDatabaseTable());
            ((DirectCollectionMapping)mapping).addReferenceKeyField(fkField, pkField);
        }
    }

    protected void setValueColumn(ColumnMetadata valueColumn) {
        this.m_valueColumn = valueColumn;
    }
}

