/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.util;

import java.util.Arrays;

public final class CharTypes {
    static final char[] HEX_CHARS;
    static final int[] sInputCodes;
    static final int[] sInputCodesUtf8;
    static final int[] sInputCodesComment;
    static final int[] sOutputEscapes;
    static final int[] sHexValues;

    private CharTypes() {
    }

    public static final int[] getInputCodeLatin1() {
        return sInputCodes;
    }

    public static final int[] getInputCodeUtf8() {
        return sInputCodesUtf8;
    }

    public static final int[] getInputCodeComment() {
        return sInputCodesComment;
    }

    public static final int[] getOutputEscapes() {
        return sOutputEscapes;
    }

    public static int charToHex(int n) {
        return n > 127 ? -1 : sHexValues[n];
    }

    public static void appendQuoted(StringBuilder stringBuilder, String string) {
        int[] nArray = sOutputEscapes;
        int n = nArray.length;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= n || nArray[c] == 0) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('\\');
            int n3 = nArray[c];
            if (n3 < 0) {
                stringBuilder.append('u');
                stringBuilder.append('0');
                stringBuilder.append('0');
                int n4 = -(n3 + 1);
                stringBuilder.append(HEX_CHARS[n4 >> 4]);
                stringBuilder.append(HEX_CHARS[n4 & 0xF]);
                continue;
            }
            stringBuilder.append((char)n3);
        }
    }

    static {
        int n;
        int n2;
        HEX_CHARS = "0123456789ABCDEF".toCharArray();
        int[] nArray = new int[256];
        for (n2 = 0; n2 < 32; ++n2) {
            nArray[n2] = -1;
        }
        nArray[34] = 1;
        nArray[92] = 1;
        sInputCodes = nArray;
        nArray = new int[sInputCodes.length];
        System.arraycopy(sInputCodes, 0, nArray, 0, sInputCodes.length);
        for (n2 = 128; n2 < 256; ++n2) {
            int n3 = (n2 & 0xE0) == 192 ? 2 : ((n2 & 0xF0) == 224 ? 3 : ((n2 & 0xF8) == 240 ? 4 : -1));
            nArray[n2] = n3;
        }
        sInputCodesUtf8 = nArray;
        sInputCodesComment = new int[256];
        System.arraycopy(sInputCodesUtf8, 128, sInputCodesComment, 128, 128);
        Arrays.fill(sInputCodesComment, 0, 32, -1);
        CharTypes.sInputCodesComment[9] = 0;
        CharTypes.sInputCodesComment[10] = 10;
        CharTypes.sInputCodesComment[13] = 13;
        CharTypes.sInputCodesComment[42] = 42;
        nArray = new int[256];
        for (n2 = 0; n2 < 32; ++n2) {
            nArray[n2] = -(n2 + 1);
        }
        nArray[34] = 34;
        nArray[92] = 92;
        nArray[8] = 98;
        nArray[9] = 116;
        nArray[12] = 102;
        nArray[10] = 110;
        nArray[13] = 114;
        sOutputEscapes = nArray;
        sHexValues = new int[128];
        Arrays.fill(sHexValues, -1);
        for (n = 0; n < 10; ++n) {
            CharTypes.sHexValues[48 + n] = n;
        }
        for (n = 0; n < 6; ++n) {
            CharTypes.sHexValues[97 + n] = 10 + n;
            CharTypes.sHexValues[65 + n] = 10 + n;
        }
    }
}

