/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.appserv.connectors.internal.spi.BadConnectionEventListener;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.LocalTransaction;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.spi.ManagedConnectionMetaData;
import com.sun.gjc.spi.XAResourceImpl;
import com.sun.gjc.spi.base.CacheObjectKey;
import com.sun.gjc.spi.base.CallableStatementWrapper;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.spi.base.ConnectionWrapper;
import com.sun.gjc.spi.base.PreparedStatementWrapper;
import com.sun.gjc.spi.base.datastructure.Cache;
import com.sun.gjc.spi.base.datastructure.CacheFactory;
import com.sun.gjc.util.SQLTraceDelegator;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class ManagedConnection
implements javax.resource.spi.ManagedConnection,
LazyEnlistableManagedConnection,
DissociatableManagedConnection {
    public static final int ISNOTAPOOLEDCONNECTION = 0;
    public static final int ISPOOLEDCONNECTION = 1;
    public static final int ISXACONNECTION = 2;
    protected boolean isDestroyed = false;
    protected boolean isUsable = true;
    protected boolean initSqlExecuted = false;
    protected int connectionCount = 0;
    protected int connectionType = 0;
    protected PooledConnection pc = null;
    protected Connection actualConnection = null;
    protected Hashtable connectionHandles;
    protected PrintWriter logWriter;
    protected PasswordCredential passwdCredential;
    private javax.resource.spi.ManagedConnectionFactory mcf = null;
    protected XAResource xar = null;
    protected ConnectionHolder myLogicalConnection = null;
    protected int lastTransactionIsolationLevel;
    protected boolean isClean = true;
    protected boolean transactionInProgress = false;
    protected ConnectionEventListener listener = null;
    protected ConnectionEvent ce = null;
    private boolean defaultAutoCommitValue;
    private boolean lastAutoCommitValue = this.defaultAutoCommitValue = true;
    private boolean markedForRemoval = false;
    private int statementTimeout;
    private Cache statementCache = null;
    private int cacheSize;
    private String cacheType;
    private boolean statementCaching;
    private SQLTraceDelegator sqlTraceDelegator;
    protected static final Logger _logger = LogDomains.getLogger(ManagedConnection.class, (String)"javax.enterprise.resource.resourceadapter");
    protected static final StringManager localStrings = StringManager.getManager(DataSourceObjectBuilder.class);

    public ManagedConnection(PooledConnection pooledConn, Connection sqlConn, PasswordCredential passwdCred, javax.resource.spi.ManagedConnectionFactory mcf, int statementCacheSize, String statementCacheType, SQLTraceDelegator delegator) throws ResourceException {
        if (pooledConn == null && sqlConn == null) {
            String i18nMsg = localStrings.getString("jdbc.conn_obj_null");
            throw new ResourceException(i18nMsg);
        }
        if (this.connectionType == 0) {
            this.actualConnection = sqlConn;
        }
        this.pc = pooledConn;
        this.connectionHandles = new Hashtable();
        this.passwdCredential = passwdCred;
        this.sqlTraceDelegator = delegator;
        this.mcf = mcf;
        if (this.passwdCredential != null && !this.mcf.equals(this.passwdCredential.getManagedConnectionFactory())) {
            String i18nMsg = localStrings.getString("jdbc.mc_construct_err");
            throw new ResourceException(i18nMsg);
        }
        this.logWriter = mcf.getLogWriter();
        this.ce = new ConnectionEvent((javax.resource.spi.ManagedConnection)this, 1);
        this.tuneStatementCaching(statementCacheSize, statementCacheType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInitSql(String initSql) {
        _logger.log(Level.FINE, "jdbc.execute_init_sql_start");
        PreparedStatement stmt = null;
        if (initSql != null && !initSql.equalsIgnoreCase("null") && !initSql.equals("")) {
            try {
                stmt = this.actualConnection.prepareStatement(initSql);
                _logger.log(Level.FINE, "jdbc.executing_init_sql", initSql);
                stmt.execute();
            }
            catch (SQLException sqle) {
                _logger.log(Level.WARNING, "jdbc.exc_init_sql_error", initSql);
                this.initSqlExecuted = false;
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    _logger.log(Level.FINE, "jdbc.exc_init_sql_error_stmt_close", e.getMessage());
                }
            }
            this.initSqlExecuted = true;
        }
        _logger.log(Level.FINE, "jdbc.execute_init_sql_end");
    }

    private void tuneStatementCaching(int statementCacheSize, String statementCacheType) {
        this.cacheSize = statementCacheSize;
        this.cacheType = statementCacheType;
        if (this.cacheSize > 0) {
            try {
                this.statementCache = CacheFactory.getDataStructure(this.cacheType, this.cacheSize);
                this.statementCaching = true;
            }
            catch (ResourceException ex) {
                _logger.severe(ex.getMessage());
            }
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listener = listener;
    }

    public void associateConnection(Object connection) throws ResourceException {
        this.logFine("In associateConnection");
        this.checkIfValid();
        if (connection == null) {
            String i18nMsg = localStrings.getString("jdbc.conn_handle_null");
            throw new ResourceException(i18nMsg);
        }
        ConnectionHolder ch = (ConnectionHolder)connection;
        ManagedConnection mc = ch.getManagedConnection();
        this.isClean = false;
        ch.associateConnection(this.actualConnection, this);
        ch.setActive(true);
        this.incrementCount();
        if (mc != null) {
            mc.decrementCount();
        }
    }

    public void cleanup() throws ResourceException {
        this.logFine("In cleanup");
        this.isClean = true;
    }

    protected void invalidateAllConnectionHandles() throws ResourceException {
        Set handles = this.connectionHandles.keySet();
        Iterator iter = handles.iterator();
        try {
            while (iter.hasNext()) {
                ConnectionHolder ch = (ConnectionHolder)iter.next();
                ch.invalidate();
            }
        }
        catch (NoSuchElementException nsee) {
            throw new ResourceException("Could not find the connection handle: " + nsee.getMessage());
        }
        this.connectionHandles.clear();
    }

    private void clearStatementCache() {
        if (this.statementCache != null) {
            _logger.fine("Closing statements in statement cache");
            this.statementCache.flushCache();
            this.statementCache.clearCache();
        }
    }

    public void destroy() throws ResourceException {
        this.logFine("In destroy");
        if (this.isDestroyed) {
            return;
        }
        this.clearStatementCache();
        try {
            if (this.connectionType == 2 || this.connectionType == 1) {
                this.pc.close();
                this.pc = null;
                this.actualConnection = null;
            } else {
                this.actualConnection.close();
                this.actualConnection = null;
            }
        }
        catch (SQLException sqle) {
            this.isDestroyed = true;
            this.passwdCredential = null;
            this.connectionHandles = null;
            String i18nMsg = localStrings.getString("jdbc.error_in_destroy");
            ResourceException re = new ResourceException(i18nMsg + sqle.getMessage(), (Throwable)sqle);
            throw re;
        }
        this.isDestroyed = true;
        this.passwdCredential = null;
        this.connectionHandles = null;
    }

    public Object getConnection(Subject sub, ConnectionRequestInfo cxReqInfo) throws ResourceException {
        this.logFine("In getConnection");
        this.checkIfValid();
        this.getActualConnection();
        ManagedConnectionFactory spiMCF = (ManagedConnectionFactory)this.mcf;
        this.resetConnectionProperties(spiMCF);
        this.myLogicalConnection = spiMCF.getJdbcObjectsFactory().getConnection(this.actualConnection, this, cxReqInfo, spiMCF.isStatementWrappingEnabled(), this.sqlTraceDelegator);
        if (!this.initSqlExecuted) {
            String initSql = spiMCF.getInitSql();
            this.executeInitSql(initSql);
        }
        this.incrementCount();
        this.isClean = false;
        this.myLogicalConnection.setActive(true);
        return this.myLogicalConnection;
    }

    private void resetConnectionProperties(ManagedConnectionFactory spiMCF) throws ResourceException {
        int timeoutValue;
        if (this.isClean) {
            spiMCF.resetIsolation(this, this.lastTransactionIsolationLevel);
        }
        this.resetAutoCommit();
        String statementTimeoutString = spiMCF.getStatementTimeout();
        if (statementTimeoutString != null && (timeoutValue = Integer.valueOf(statementTimeoutString).intValue()) >= 0) {
            this.statementTimeout = timeoutValue;
        }
    }

    private void resetAutoCommit() throws ResourceException {
        if (this.defaultAutoCommitValue != this.getLastAutoCommitValue() && !this.isTransactionInProgress()) {
            try {
                this.actualConnection.setAutoCommit(this.defaultAutoCommitValue);
            }
            catch (SQLException sqle) {
                String i18nMsg = localStrings.getString("jdbc.error_during_setAutoCommit");
                throw new ResourceException(i18nMsg + sqle.getMessage(), (Throwable)sqle);
            }
            this.setLastAutoCommitValue(this.defaultAutoCommitValue);
        }
    }

    public javax.resource.spi.LocalTransaction getLocalTransaction() throws ResourceException {
        this.logFine("In getLocalTransaction");
        this.checkIfValid();
        return new LocalTransaction(this);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        this.logFine("In getLogWriter");
        this.checkIfValid();
        return this.logWriter;
    }

    public javax.resource.spi.ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.logFine("In getMetaData");
        this.checkIfValid();
        return new ManagedConnectionMetaData(this);
    }

    public XAResource getXAResource() throws ResourceException {
        this.logFine("In getXAResource");
        this.checkIfValid();
        if (this.connectionType == 2) {
            try {
                if (this.xar == null) {
                    this.xar = new XAResourceImpl(((XAConnection)this.pc).getXAResource(), this);
                }
                return this.xar;
            }
            catch (SQLException sqle) {
                throw new ResourceException(sqle.getMessage(), (Throwable)sqle);
            }
        }
        throw new NotSupportedException("Cannot get an XAResource from a non XA connection");
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
    }

    void transactionStarted() {
        this.transactionInProgress = true;
    }

    void transactionCompleted() {
        try {
            this.transactionInProgress = false;
            if ((this.connectionType == 1 || this.connectionType == 2) && this.connectionCount <= 0) {
                try {
                    this.actualConnection.close();
                    this.actualConnection = null;
                }
                catch (SQLException sqle) {
                    this.actualConnection = null;
                }
            }
        }
        catch (NullPointerException e) {
            _logger.log(Level.FINE, "jdbc.duplicateTxCompleted");
        }
        if (this.markedForRemoval) {
            this.connectionErrorOccurred(null, null);
            _logger.log(Level.INFO, "jdbc.markedForRemoval_txCompleted");
            this.markedForRemoval = false;
        }
        this.isClean = true;
    }

    public boolean isTransactionInProgress() {
        return this.transactionInProgress;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.checkIfValid();
        this.logWriter = out;
    }

    protected int getConnectionType(PooledConnection pooledConn) {
        if (pooledConn == null) {
            return 0;
        }
        if (pooledConn instanceof XAConnection) {
            return 2;
        }
        return 1;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return (ManagedConnectionFactory)this.mcf;
    }

    Connection getActualConnection() throws ResourceException {
        if (this.connectionType == 2 || this.connectionType == 1) {
            try {
                if (this.actualConnection == null) {
                    this.actualConnection = this.pc.getConnection();
                    this.setLastAutoCommitValue(this.defaultAutoCommitValue);
                }
            }
            catch (SQLException sqle) {
                throw new ResourceException(sqle.getMessage(), (Throwable)sqle);
            }
        }
        return this.actualConnection;
    }

    PasswordCredential getPasswordCredential() {
        return this.passwdCredential;
    }

    void checkIfValid() throws ResourceException {
        if (this.isDestroyed || !this.isUsable) {
            String i18nMsg = localStrings.getString("jdbc.mc_not_usable");
            throw new ResourceException(i18nMsg);
        }
    }

    public void connectionClosed(Exception e, ConnectionHolder connHolder30Object) throws SQLException {
        connHolder30Object.invalidate();
        this.decrementCount();
        this.ce.setConnectionHandle((Object)connHolder30Object);
        if (this.markedForRemoval && !this.transactionInProgress) {
            BadConnectionEventListener bcel = (BadConnectionEventListener)this.listener;
            bcel.badConnectionClosed(this.ce);
            _logger.log(Level.INFO, "jdbc.markedForRemoval_conClosed");
            this.markedForRemoval = false;
        } else {
            this.listener.connectionClosed(this.ce);
        }
    }

    void connectionErrorOccurred(Exception e, ConnectionHolder connHolderObject) {
        ConnectionEventListener cel = this.listener;
        ConnectionEvent ce = null;
        ConnectionEvent connectionEvent = ce = e == null ? new ConnectionEvent((javax.resource.spi.ManagedConnection)this, 5) : new ConnectionEvent((javax.resource.spi.ManagedConnection)this, 5, e);
        if (connHolderObject != null) {
            ce.setConnectionHandle((Object)connHolderObject);
        }
        cel.connectionErrorOccurred(ce);
        this.isUsable = false;
    }

    void XAStartOccurred() {
        try {
            this.actualConnection.setAutoCommit(false);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "XA Start [ setAutoCommit ] failure ", e);
            this.connectionErrorOccurred(e, null);
        }
    }

    void XAEndOccurred() {
        try {
            this.actualConnection.setAutoCommit(true);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "XA End [ setAutoCommit ] failure ", e);
            this.connectionErrorOccurred(e, null);
        }
    }

    public void checkIfActive(ConnectionHolder ch) throws SQLException {
        if (this.isDestroyed || !this.isUsable) {
            String i18nMsg = localStrings.getString("jdbc.conn_not_usable");
            throw new SQLException(i18nMsg);
        }
    }

    public void initializeConnectionType(int _connectionType) {
        this.connectionType = _connectionType;
    }

    public void incrementCount() {
        ++this.connectionCount;
    }

    public void decrementCount() {
        --this.connectionCount;
    }

    public void dissociateConnections() {
        this.myLogicalConnection.setManagedConnection(null);
    }

    public boolean getLastAutoCommitValue() {
        return this.lastAutoCommitValue;
    }

    public void setLastAutoCommitValue(boolean lastAutoCommitValue) {
        this.lastAutoCommitValue = lastAutoCommitValue;
    }

    public void markForRemoval(boolean flag) {
        this.markedForRemoval = flag;
    }

    public javax.resource.spi.ManagedConnectionFactory getMcf() {
        return this.mcf;
    }

    public int getStatementTimeout() {
        return this.statementTimeout;
    }

    public void setLastTransactionIsolationLevel(int isolationLevel) {
        this.lastTransactionIsolationLevel = isolationLevel;
    }

    private void logFine(String logMessage) {
        _logger.log(Level.FINE, logMessage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(ConnectionWrapper conWrapper, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.statementCaching) return conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, false);
        CacheObjectKey key = new CacheObjectKey(sql, "PS", resultSetType, resultSetConcurrency);
        PreparedStatementWrapper ps = (PreparedStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (ps != null) {
            if (!this.isFree(ps)) return conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, false);
            ps.setBusy(true);
            return ps;
        } else {
            ps = conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, true);
            ps.setBusy(true);
            this.statementCache.addToCache(key, ps, false);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(ConnectionWrapper conWrapper, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.statementCaching) return conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
        CacheObjectKey key = new CacheObjectKey(sql, "PS", resultSetType, resultSetConcurrency, resultSetHoldability);
        PreparedStatementWrapper ps = (PreparedStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (ps != null) {
            if (!this.isFree(ps)) return conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
            ps.setBusy(true);
            return ps;
        } else {
            ps = conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
            this.statementCache.addToCache(key, ps, false);
            ps.setBusy(true);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(ConnectionWrapper conWrapper, String sql, String[] columnNames) throws SQLException {
        if (!this.statementCaching) return conWrapper.prepareCachedStatement(sql, columnNames, false);
        CacheObjectKey key = new CacheObjectKey(sql, "PS", columnNames);
        PreparedStatementWrapper ps = (PreparedStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (ps != null) {
            if (!this.isFree(ps)) return conWrapper.prepareCachedStatement(sql, columnNames, false);
            ps.setBusy(true);
            return ps;
        } else {
            ps = conWrapper.prepareCachedStatement(sql, columnNames, true);
            this.statementCache.addToCache(key, ps, false);
            ps.setBusy(true);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(ConnectionWrapper conWrapper, String sql, int[] columnIndexes) throws SQLException {
        if (!this.statementCaching) return conWrapper.prepareCachedStatement(sql, columnIndexes, false);
        CacheObjectKey key = new CacheObjectKey(sql, "PS", columnIndexes);
        PreparedStatementWrapper ps = (PreparedStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (ps != null) {
            if (!this.isFree(ps)) return conWrapper.prepareCachedStatement(sql, columnIndexes, false);
            ps.setBusy(true);
            return ps;
        } else {
            ps = conWrapper.prepareCachedStatement(sql, columnIndexes, true);
            this.statementCache.addToCache(key, ps, false);
            ps.setBusy(true);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(ConnectionWrapper conWrapper, String sql, int autoGeneratedKeys) throws SQLException {
        if (!this.statementCaching) return conWrapper.prepareCachedStatement(sql, autoGeneratedKeys, false);
        CacheObjectKey key = new CacheObjectKey(sql, "PS", autoGeneratedKeys);
        PreparedStatementWrapper ps = (PreparedStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (ps != null) {
            if (!this.isFree(ps)) return conWrapper.prepareCachedStatement(sql, autoGeneratedKeys, false);
            ps.setBusy(true);
            return ps;
        } else {
            ps = conWrapper.prepareCachedStatement(sql, autoGeneratedKeys, true);
            this.statementCache.addToCache(key, ps, false);
            ps.setBusy(true);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableStatement prepareCachedCallableStatement(ConnectionWrapper conWrapper, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.statementCaching) return conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, false);
        CacheObjectKey key = new CacheObjectKey(sql, "CS", resultSetType, resultSetConcurrency);
        CallableStatementWrapper cs = (CallableStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (cs != null) {
            if (!this.isFree(cs)) return conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, false);
            cs.setBusy(true);
            return cs;
        } else {
            cs = conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, true);
            this.statementCache.addToCache(key, cs, false);
            cs.setBusy(true);
        }
        return cs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableStatement prepareCachedCallableStatement(ConnectionWrapper conWrapper, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.statementCaching) return conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
        CacheObjectKey key = new CacheObjectKey(sql, "CS", resultSetType, resultSetConcurrency, resultSetHoldability);
        CallableStatementWrapper cs = (CallableStatementWrapper)this.statementCache.checkAndUpdateCache(key);
        if (cs != null) {
            if (!this.isFree(cs)) return conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
            cs.setBusy(true);
            return cs;
        } else {
            cs = conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
            this.statementCache.addToCache(key, cs, false);
            cs.setBusy(true);
        }
        return cs;
    }

    boolean isFree(PreparedStatementWrapper cachedps) {
        return !cachedps.isBusy();
    }
}

