/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.event;

import com.sun.data.provider.SortCriteria;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.util.LogUtil;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class TableSortActionListener
implements ActionListener {
    public void processAction(ActionEvent event) throws AbortProcessingException {
        UIComponent source;
        UIComponent uIComponent = source = event != null ? (UIComponent)event.getSource() : null;
        if (source == null) {
            this.log("processAction", "Cannot process action, ActionEvent source is null");
            return;
        }
        TableColumn col = this.getTableColumnAncestor(source);
        if (col != null) {
            this.processTableColumn(col, source.getId());
        } else {
            Table table = this.getTableAncestor(source);
            if (table != null) {
                this.processTable(table, source.getId());
            } else {
                this.log("processAction", "Cannot process action, Table is null");
            }
        }
    }

    private void processTable(Table component, String id) {
        if (component == null) {
            this.log("processTable", "Cannot process Table action, Table is null");
            return;
        }
        if (id.equals("_clearSortButton") || id.equals("_sortPanelSubmitButton")) {
            Iterator kids = component.getTableRowGroupChildren();
            while (kids.hasNext()) {
                TableRowGroup group = (TableRowGroup)((Object)kids.next());
                group.clearSort();
            }
        }
        if (id.equals("_sortPanelSubmitButton")) {
            this.customSort(component);
        }
    }

    private void processTableColumn(TableColumn component, String id) {
        if (component == null) {
            this.log("processTableColumn", "Cannot process TableColumn action, TableColumn is null");
            return;
        }
        Table table = component.getTableAncestor();
        if (table != null && table.getColumnHeadersCount() > 1) {
            TableRowGroup group = component.getTableRowGroupAncestor();
            this.setSort(group, id, component.getSortCriteria());
        } else {
            this.sort(table, id, component.getSortCriteria());
        }
    }

    private void sort(Table component, String id, SortCriteria criteria) {
        if (component == null || criteria == null) {
            this.log("sort", "Cannot sort, Table or SortCriteria is null");
            return;
        }
        int index = this.getNodeIndex(component, criteria.getCriteriaKey());
        Iterator kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group;
            TableColumn col = this.getTableColumn(group = (TableRowGroup)((Object)kids.next()), index);
            this.setSort(group, id, col != null ? col.getSortCriteria() : null);
        }
    }

    private void setSort(TableRowGroup component, String id, SortCriteria criteria) {
        if (component == null) {
            this.log("setSort", "Cannot set sort, TableRowGroup is null");
            return;
        }
        if (id.equals("_addSortButton")) {
            component.addSort(criteria);
        } else if (id.equals("_selectSortButton") || id.equals("_primarySortButton") || id.equals("_primarySortLink")) {
            component.clearSort();
            component.addSort(criteria);
        } else if (id.equals("_toggleSortButton")) {
            if (criteria != null) {
                criteria.setAscending(component.isDescendingSort(criteria));
            }
            component.addSort(criteria);
        } else {
            this.log("setSort", "Cannot add sort, unknown component Id: " + id);
        }
    }

    private void customSort(Table component) {
        int index;
        UIComponent panels = component.getFacet("_embeddedPanels");
        if (panels == null) {
            this.log("customSort", "Cannot custom sort, embedded panels facet is null");
            return;
        }
        Map map = panels.getFacets();
        UIComponent primarySortColumnMenu = (UIComponent)map.get("_primarySortColumnMenu");
        UIComponent primarySortOrderMenu = (UIComponent)map.get("_primarySortOrderMenu");
        UIComponent secondarySortColumnMenu = (UIComponent)map.get("_secondarySortColumnMenu");
        UIComponent secondarySortOrderMenu = (UIComponent)map.get("_secondarySortOrderMenu");
        UIComponent tertiarySortColumnMenu = (UIComponent)map.get("_tertiarySortColumnMenu");
        UIComponent tertiarySortOrderMenu = (UIComponent)map.get("_tertiarySortOrderMenu");
        if (primarySortColumnMenu != null && primarySortOrderMenu != null && primarySortColumnMenu instanceof DropDown && primarySortOrderMenu instanceof DropDown) {
            index = this.getNodeIndex(component, (String)((DropDown)primarySortColumnMenu).getSelected());
            this.setCustomSort(component, index, Boolean.valueOf((String)((DropDown)primarySortOrderMenu).getSelected()));
        } else {
            this.log("customSort", "Cannot set custom sort, primary sort column menu is null");
        }
        if (secondarySortColumnMenu != null && secondarySortOrderMenu != null && secondarySortColumnMenu instanceof DropDown && secondarySortOrderMenu instanceof DropDown) {
            index = this.getNodeIndex(component, (String)((DropDown)secondarySortColumnMenu).getSelected());
            this.setCustomSort(component, index, Boolean.valueOf((String)((DropDown)secondarySortOrderMenu).getSelected()));
        } else {
            this.log("customSort", "Cannot set custom sort, secondary sort column menu is null");
        }
        if (tertiarySortColumnMenu != null && tertiarySortOrderMenu != null && tertiarySortColumnMenu instanceof DropDown && tertiarySortOrderMenu instanceof DropDown) {
            index = this.getNodeIndex(component, (String)((DropDown)tertiarySortColumnMenu).getSelected());
            this.setCustomSort(component, index, Boolean.valueOf((String)((DropDown)tertiarySortOrderMenu).getSelected()));
        } else {
            this.log("customSort", "Cannot set custom sort, tertiary sort column menu is null");
        }
    }

    private void setCustomSort(Table component, int index, boolean descending) {
        if (component == null || index < 0) {
            this.log("setCustomSort", "Cannot set custom sort, Table is null or index < 0");
            return;
        }
        Iterator kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            SortCriteria criteria;
            TableRowGroup group = (TableRowGroup)((Object)kids.next());
            TableColumn col = this.getTableColumn(group, index);
            SortCriteria sortCriteria = criteria = col != null ? col.getSortCriteria() : null;
            if (criteria != null) {
                criteria.setAscending(!descending);
            }
            group.addSort(criteria);
        }
    }

    private int getNodeIndex(Table component, String criteriaKey) {
        if (component == null || criteriaKey == null || criteriaKey.length() == 0) {
            this.log("getNodeIndex", "Cannot obtain node index, Table or sort criteria key is null");
            return -1;
        }
        TableRowGroup group = component.getTableRowGroupChild();
        if (group != null) {
            Integer index = new Integer(-1);
            Iterator kids = group.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                int result = this.getNodeIndex(col, criteriaKey, index = new Integer(index + 1));
                if (result <= -1) continue;
                return result;
            }
        } else {
            this.log("getNodeIndex", "Cannot obtain node index, TableRowGroup is null");
        }
        return -1;
    }

    private int getNodeIndex(TableColumn component, String criteriaKey, Integer index) {
        SortCriteria criteria;
        if (component == null || criteriaKey == null || criteriaKey.length() == 0) {
            this.log("getNodeIndex", "Cannot obtain node index, TableColumn or sort criteria key is null");
            return -1;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                int result = this.getNodeIndex(col, criteriaKey, index = new Integer(index + 1));
                if (result <= -1) continue;
                return result;
            }
        }
        String key = (criteria = component.getSortCriteria()) != null ? criteria.getCriteriaKey() : null;
        return key != null && key.equals(criteriaKey) ? index : -1;
    }

    private TableColumn getTableColumn(TableRowGroup component, int index) {
        if (component == null) {
            this.log("getTableColumn", "Cannot obtain TableColumn component, TableRowGroup is null");
            return null;
        }
        ++index;
        Iterator kids = component.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn col = (TableColumn)((Object)kids.next());
            TableColumn result = this.getTableColumn(col, --index);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private TableColumn getTableColumn(TableColumn component, int index) {
        if (component == null) {
            this.log("getTableColumn", "Cannot obtain TableColumn component, TableColumn is null");
            return null;
        }
        Iterator kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = (TableColumn)((Object)kids.next());
                TableColumn result = this.getTableColumn(col, --index);
                if (result == null) continue;
                return result;
            }
        }
        if (index == 0) {
            return component;
        }
        this.log("getTableColumn", "Cannot obtain TableColumn component, cannot match node index");
        return null;
    }

    private Table getTableAncestor(UIComponent component) {
        while (component != null) {
            if (!((component = component.getParent()) instanceof Table)) continue;
            return (Table)component;
        }
        return null;
    }

    private TableColumn getTableColumnAncestor(UIComponent component) {
        while (component != null) {
            if (!((component = component.getParent()) instanceof TableColumn)) continue;
            return (TableColumn)component;
        }
        return null;
    }

    private void log(String method, String message) {
        Class<?> clazz = this.getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }
}

