/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.ajax;

import com.sun.webui.jsf.component.ProgressBar;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.json.JSONException;
import org.json.JSONObject;

public class ProgressBarRenderer
extends Renderer {
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String id = component.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String buttonId = id + "_" + "controlType";
        Object valueObject = params.get(buttonId);
        String value = null;
        if (valueObject != null) {
            value = ((String)valueObject).trim();
            ProgressBar progressBar = (ProgressBar)component;
            if (ProgressBar.TASK_STOPPED.equals(value)) {
                progressBar.setTaskState(ProgressBar.TASK_STOPPED);
            } else if (ProgressBar.TASK_PAUSED.equals(value)) {
                progressBar.setTaskState(ProgressBar.TASK_PAUSED);
            } else if (ProgressBar.TASK_RESUMED.equals(value)) {
                progressBar.setTaskState(ProgressBar.TASK_RESUMED);
            } else if (ProgressBar.TASK_CANCELED.equals(value)) {
                progressBar.setTaskState(ProgressBar.TASK_CANCELED);
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        UIComponent bottomTextFacet;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ProgressBar progressBar = (ProgressBar)component;
        int progress = progressBar.getProgress();
        String status = progressBar.getStatus();
        String topText = progressBar.getDescription();
        String logMessage = progressBar.getLogMessage();
        String failedStateText = progressBar.getFailedStateText();
        UIComponent topTextFacet = component.getFacet("progressTextTop");
        if (topTextFacet != null) {
            topText = null;
        }
        if ((bottomTextFacet = component.getFacet("progressTextBottom")) != null) {
            status = null;
        }
        String taskState = progressBar.getTaskState();
        try {
            JSONObject json = new JSONObject();
            json.put("taskState", (Object)taskState);
            json.put("progress", (Object)String.valueOf(progress));
            json.put("status", (Object)status);
            json.put("topText", (Object)topText);
            json.put("logMessage", (Object)logMessage);
            json.put("failedStateText", (Object)failedStateText);
            json.write((Writer)context.getResponseWriter());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

