/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.servicetags.util;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLValidator {
    public boolean validate(Document doc, String schemaFile) {
        boolean isValid = false;
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            File schemaLocation = new File(schemaFile);
            Schema schema = factory.newSchema(schemaLocation);
            Validator validator = schema.newValidator();
            DOMSource source = new DOMSource(doc);
            validator.validate(source);
            isValid = true;
        }
        catch (SAXException se) {
            isValid = false;
            System.err.println(se.getMessage());
            se.printStackTrace();
        }
        catch (IOException ioe) {
            isValid = false;
            System.err.println(ioe.getMessage());
            ioe.printStackTrace();
        }
        return isValid;
    }

    public static void main(String[] args) {
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(new File(args[0]));
            XMLValidator validator = new XMLValidator();
            validator.validate(doc, args[1]);
            System.exit(0);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }
}

