/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.orb.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-iiop-listener")
@Scoped(value=PerLookup.class)
@I18n(value="delete.iiop.listener")
public class DeleteIiopListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteIiopListener.class);
    @Param(name="listener_id", primary=true)
    String listener_id;
    @Param(optional=true)
    String target = "server";
    @Inject
    Configs configs;
    @Inject
    Servers servers;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        IiopService iiopService = config.getIiopService();
        if (!this.isIIOPListenerExists(iiopService)) {
            report.setMessage(localStrings.getLocalString("delete.iiop.listener.notexists", "IIOP Listener {0} does not exist.", new Object[]{this.listener_id}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<IiopService>(){

                public Object run(IiopService param) throws PropertyVetoException, TransactionFailure {
                    List listenerList = param.getIiopListener();
                    for (IiopListener listener : listenerList) {
                        String currListenerId = listener.getId();
                        if (currListenerId == null || !currListenerId.equals(DeleteIiopListener.this.listener_id)) continue;
                        listenerList.remove(listener);
                        break;
                    }
                    return listenerList;
                }
            }, (ConfigBeanProxy)iiopService);
            report.setMessage(localStrings.getLocalString("delete.iiop.listener.success", "IIOP Listener {0} deleted", new Object[]{this.listener_id}));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            String actual = e.getMessage();
            report.setMessage(localStrings.getLocalString("delete.iiop.listener.fail", "failed", new Object[]{this.listener_id, actual}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean isIIOPListenerExists(IiopService iiopService) {
        for (IiopListener listener : iiopService.getIiopListener()) {
            String currListenerId = listener.getId();
            if (currListenerId == null || !currListenerId.equals(this.listener_id)) continue;
            return true;
        }
        return false;
    }
}

