/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.util.HashMap;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.util.ASMifierClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.util.PrintCodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.util.attrs.ASMifiable;

public class ASMifierCodeVisitor
extends PrintCodeVisitor {
    private final HashMap labelNames = new HashMap();

    public void printInsn(int opcode) {
        this.buf.append("cv.visitInsn(").append(OPCODES[opcode]).append(");\n");
    }

    public void printIntInsn(int opcode, int operand) {
        this.buf.append("cv.visitIntInsn(").append(OPCODES[opcode]).append(", ").append(operand).append(");\n");
    }

    public void printVarInsn(int opcode, int var) {
        this.buf.append("cv.visitVarInsn(").append(OPCODES[opcode]).append(", ").append(var).append(");\n");
    }

    public void printTypeInsn(int opcode, String desc) {
        this.buf.append("cv.visitTypeInsn(").append(OPCODES[opcode]).append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, desc);
        this.buf.append(");\n");
    }

    public void printFieldInsn(int opcode, String owner, String name, String desc) {
        this.buf.append("cv.visitFieldInsn(").append(OPCODES[opcode]).append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, owner);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, name);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, desc);
        this.buf.append(");\n");
    }

    public void printMethodInsn(int opcode, String owner, String name, String desc) {
        this.buf.append("cv.visitMethodInsn(").append(OPCODES[opcode]).append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, owner);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, name);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, desc);
        this.buf.append(");\n");
    }

    public void printJumpInsn(int opcode, Label label) {
        this.declareLabel(label);
        this.buf.append("cv.visitJumpInsn(").append(OPCODES[opcode]).append(", ");
        this.appendLabel(label);
        this.buf.append(");\n");
    }

    public void printLabel(Label label) {
        this.declareLabel(label);
        this.buf.append("cv.visitLabel(");
        this.appendLabel(label);
        this.buf.append(");\n");
    }

    public void printLdcInsn(Object cst) {
        this.buf.append("cv.visitLdcInsn(");
        ASMifierClassVisitor.appendConstant(this.buf, cst);
        this.buf.append(");\n");
    }

    public void printIincInsn(int var, int increment) {
        this.buf.append("cv.visitIincInsn(").append(var).append(", ").append(increment).append(");\n");
    }

    public void printTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        int i = 0;
        while (i < labels.length) {
            this.declareLabel(labels[i]);
            ++i;
        }
        this.declareLabel(dflt);
        this.buf.append("cv.visitTableSwitchInsn(").append(min).append(", ").append(max).append(", ");
        this.appendLabel(dflt);
        this.buf.append(", new Label[] {");
        i = 0;
        while (i < labels.length) {
            this.buf.append(i == 0 ? " " : ", ");
            this.appendLabel(labels[i]);
            ++i;
        }
        this.buf.append(" });\n");
    }

    public void printLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        int i = 0;
        while (i < labels.length) {
            this.declareLabel(labels[i]);
            ++i;
        }
        this.declareLabel(dflt);
        this.buf.append("cv.visitLookupSwitchInsn(");
        this.appendLabel(dflt);
        this.buf.append(", new int[] {");
        i = 0;
        while (i < keys.length) {
            this.buf.append(i == 0 ? " " : ", ").append(keys[i]);
            ++i;
        }
        this.buf.append(" }, new Label[] {");
        i = 0;
        while (i < labels.length) {
            this.buf.append(i == 0 ? " " : ", ");
            this.appendLabel(labels[i]);
            ++i;
        }
        this.buf.append(" });\n");
    }

    public void printMultiANewArrayInsn(String desc, int dims) {
        this.buf.append("cv.visitMultiANewArrayInsn(");
        ASMifierClassVisitor.appendConstant(this.buf, desc);
        this.buf.append(", ").append(dims).append(");\n");
    }

    public void printTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.buf.append("cv.visitTryCatchBlock(");
        this.appendLabel(start);
        this.buf.append(", ");
        this.appendLabel(end);
        this.buf.append(", ");
        this.appendLabel(handler);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, type);
        this.buf.append(");\n");
    }

    public void printMaxs(int maxStack, int maxLocals) {
        this.buf.append("cv.visitMaxs(").append(maxStack).append(", ").append(maxLocals).append(");\n");
    }

    public void printLocalVariable(String name, String desc, Label start, Label end, int index) {
        this.buf.append("cv.visitLocalVariable(");
        ASMifierClassVisitor.appendConstant(this.buf, name);
        this.buf.append(", ");
        ASMifierClassVisitor.appendConstant(this.buf, desc);
        this.buf.append(", ");
        this.appendLabel(start);
        this.buf.append(", ");
        this.appendLabel(end);
        this.buf.append(", ").append(index).append(");\n");
    }

    public void printLineNumber(int line, Label start) {
        this.buf.append("cv.visitLineNumber(").append(line).append(", ");
        this.appendLabel(start);
        this.buf.append(");\n");
    }

    public void printAttribute(Attribute attr) {
        if (attr instanceof ASMifiable) {
            this.buf.append("// CODE ATTRIBUTE\n");
            ((ASMifiable)((Object)attr)).asmify(this.buf, "cv", this.labelNames);
        } else {
            this.buf.append("// WARNING! skipped a non standard code attribute of type \"");
            this.buf.append(attr.type).append("\"\n");
        }
    }

    private void declareLabel(Label l) {
        String name = (String)this.labelNames.get(l);
        if (name == null) {
            name = "l" + this.labelNames.size();
            this.labelNames.put(l, name);
            this.buf.append("Label ").append(name).append(" = new Label();\n");
        }
    }

    private void appendLabel(Label l) {
        this.buf.append((String)this.labelNames.get(l));
    }
}

