/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Check {
    public static void doChecks(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT CS.CONSTRAINTNAME, CS.TABLEID, CS.SCHEMAID, CK.CHECKDEFINITION FROM SYS.SYSCONSTRAINTS CS, SYS.SYSCHECKS CK WHERE CS.CONSTRAINTID = CK.CONSTRAINTID AND CS.STATE != 'D' ORDER BY CS.TABLEID");
        boolean bl = true;
        while (resultSet.next()) {
            String string = resultSet.getString(2);
            String string2 = dblook.lookupTableId(string);
            if (dblook.isExcludedTable(string2)) continue;
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_ChecksHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            StringBuffer stringBuffer = DB_Check.createCheckString(string2, resultSet);
            Logs.writeToNewDDL(stringBuffer.toString());
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
        statement.close();
        resultSet.close();
    }

    private static StringBuffer createCheckString(String string, ResultSet resultSet) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("ALTER TABLE ");
        stringBuffer.append(string);
        stringBuffer.append(" ADD");
        String string2 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
        stringBuffer.append(" CONSTRAINT ");
        stringBuffer.append(string2);
        stringBuffer.append(" CHECK ");
        stringBuffer.append(dblook.removeNewlines(resultSet.getString(4)));
        return stringBuffer;
    }
}

