/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupMapper {
    private Map<String, ArrayList<String>> groupMappingTable = new HashMap<String, ArrayList<String>>();

    public void parse(String mappingStr) {
        StringTokenizer tokenizer = new StringTokenizer(mappingStr, ";");
        while (tokenizer.hasMoreElements()) {
            String mapping = tokenizer.nextToken();
            String[] mappingGroups = mapping.split(",");
            String mappedGroup = null;
            int indexOfArrow = mapping.indexOf("->");
            if (indexOfArrow > 0 && mappingGroups != null && mappingGroups.length > 0) {
                String tmpGroup = mapping.substring(indexOfArrow + 2);
                mappedGroup = tmpGroup.trim();
            }
            this.validate(mappedGroup, mappingGroups);
            for (String grp : mappingGroups) {
                int aIndex = grp.indexOf("->");
                String theGroup = null;
                if (aIndex > 0) {
                    String tGrp = grp.substring(0, aIndex);
                    theGroup = tGrp.trim();
                } else {
                    theGroup = grp.trim();
                }
                ArrayList<String> mappedGroupList = this.groupMappingTable.get(theGroup);
                if (mappedGroupList == null) {
                    mappedGroupList = new ArrayList();
                }
                mappedGroupList.add(mappedGroup);
                this.groupMappingTable.put(theGroup, mappedGroupList);
            }
        }
    }

    public void getMappedGroups(String group, ArrayList<String> result) {
        if (result == null) {
            throw new RuntimeException("result argument cannot be NULL");
        }
        ArrayList<String> mappedGrps = this.groupMappingTable.get(group);
        if (mappedGrps == null || mappedGrps.isEmpty()) {
            return;
        }
        this.addUnique(result, mappedGrps);
        ArrayList<String> result1 = new ArrayList<String>();
        for (String str : mappedGrps) {
            this.getMappedGroups(group, str, result1);
        }
        this.addUnique(result, result1);
    }

    private void addUnique(ArrayList<String> dest, ArrayList<String> src) {
        for (String str : src) {
            if (dest.contains(str)) continue;
            dest.add(str);
        }
    }

    private void getMappedGroups(String group, String str, ArrayList<String> result) {
        ArrayList<String> mappedGrps = this.groupMappingTable.get(str);
        if (mappedGrps == null || mappedGrps.isEmpty()) {
            return;
        }
        if (mappedGrps.contains(group)) {
            throw new RuntimeException("Illegal Mapping: cycle detected with group'" + group);
        }
        this.addUnique(result, mappedGrps);
        for (String str1 : mappedGrps) {
            this.getMappedGroups(group, str1, result);
        }
    }

    private void validate(String mappedGroup, String[] mappingGroups) {
        for (String str : mappingGroups) {
            int aIndex = str.indexOf("->");
            String theGroup = null;
            theGroup = aIndex > 0 ? str.substring(0, aIndex) : str;
            if (!theGroup.equals(mappedGroup)) continue;
            throw new RuntimeException("Illegal Mapping: Identity Mapping of group '" + theGroup + "' to '" + theGroup + "'");
        }
    }
}

