/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.agent;

import com.sun.btrace.BTraceRuntime;
import com.sun.btrace.BTraceUtils;
import com.sun.btrace.agent.Client;
import com.sun.btrace.agent.Main;
import com.sun.btrace.comm.Command;
import com.sun.btrace.comm.EventCommand;
import com.sun.btrace.comm.ExitCommand;
import com.sun.btrace.comm.InstrumentCommand;
import com.sun.btrace.comm.WireIO;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.instrument.Instrumentation;
import java.net.Socket;

class RemoteClient
extends Client {
    private volatile Socket sock;
    private volatile ObjectInputStream ois;
    private volatile ObjectOutputStream oos;

    RemoteClient(Instrumentation inst, Socket sock) throws IOException {
        super(inst);
        this.sock = sock;
        this.ois = new ObjectInputStream(sock.getInputStream());
        this.oos = new ObjectOutputStream(sock.getOutputStream());
        Command cmd = WireIO.read((ObjectInput)this.ois);
        if (cmd.getType() == 3) {
            Class btraceClazz;
            if (this.debug) {
                Main.debugPrint("got instrument command");
            }
            if ((btraceClazz = this.loadClass((InstrumentCommand)cmd)) == null) {
                throw new RuntimeException("can not load BTrace class");
            }
        } else {
            this.errorExit(new IllegalArgumentException("expecting instrument command!"));
            throw new IOException("expecting instrument command!");
        }
        Thread cmdHandler = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                BTraceRuntime.enter();
                try {
                    block8: while (true) {
                        Command cmd = WireIO.read((ObjectInput)RemoteClient.this.ois);
                        switch (cmd.getType()) {
                            case 2: {
                                ExitCommand ecmd = (ExitCommand)cmd;
                                if (RemoteClient.this.debug) {
                                    Main.debugPrint("received exit command");
                                }
                                BTraceRuntime.leave();
                                BTraceRuntime.enter((BTraceRuntime)RemoteClient.this.getRuntime());
                                try {
                                    if (RemoteClient.this.debug) {
                                        Main.debugPrint("calling BTraceUtils.exit()");
                                    }
                                    BTraceUtils.exit((int)ecmd.getExitCode());
                                    return;
                                }
                                catch (Throwable th) {
                                    if (RemoteClient.this.debug) {
                                        Main.debugPrint(th);
                                    }
                                    BTraceRuntime.handleException((Throwable)th);
                                }
                                return;
                            }
                            case 1: {
                                RemoteClient.this.getRuntime().handleEvent((EventCommand)cmd);
                                continue block8;
                            }
                        }
                        if (!RemoteClient.this.debug) continue;
                        Main.debugPrint("received " + cmd);
                    }
                }
                catch (Exception exp) {
                    if (!RemoteClient.this.debug) return;
                    Main.debugPrint(exp);
                    return;
                }
            }
        });
        cmdHandler.setDaemon(true);
        if (this.debug) {
            Main.debugPrint("starting client command handler thread");
        }
        cmdHandler.start();
    }

    public void onCommand(Command cmd) throws IOException {
        if (this.oos == null) {
            throw new IOException("no output stream");
        }
        this.oos.reset();
        switch (cmd.getType()) {
            case 2: {
                if (this.debug) {
                    Main.debugPrint("client " + this.getClassName() + ": got " + cmd);
                }
                WireIO.write((ObjectOutput)this.oos, (Command)cmd);
                this.onExit(((ExitCommand)cmd).getExitCode());
                break;
            }
            default: {
                if (this.debug) {
                    Main.debugPrint("client " + this.getClassName() + ": got " + cmd);
                }
                WireIO.write((ObjectOutput)this.oos, (Command)cmd);
            }
        }
    }

    @Override
    protected synchronized void closeAll() throws IOException {
        if (this.oos != null) {
            this.oos.close();
        }
        if (this.ois != null) {
            this.ois.close();
        }
        if (this.sock != null) {
            this.sock.close();
        }
    }
}

