/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class EjbReferenceDescriptor
extends EnvironmentProperty
implements EjbReference,
NamedDescriptor {
    private EjbDescriptor ejbDescriptor;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbReferenceDescriptor.class);
    private BundleDescriptor referringBundle;
    private String refType = null;
    private String refHomeIntf = null;
    private String refIntf = null;
    private boolean isLocal = false;
    private String ejbLink = null;
    private String lookupName = null;

    public EjbReferenceDescriptor(EjbReferenceDescriptor other) {
        super(other);
        this.isLocal = other.isLocal;
        this.refType = other.refType;
        this.refHomeIntf = other.refHomeIntf;
        this.refIntf = other.refIntf;
        this.ejbLink = other.ejbLink;
        this.lookupName = other.lookupName;
        this.referringBundle = other.referringBundle;
        this.ejbDescriptor = other.ejbDescriptor;
        if (this.ejbDescriptor != null) {
            this.ejbDescriptor.addEjbReferencer(this);
        }
    }

    public EjbReferenceDescriptor(String name, String description, EjbDescriptor ejbDescriptor) {
        super(name, "", description);
        this.setEjbDescriptor(ejbDescriptor);
    }

    public EjbReferenceDescriptor(String name, String description, EjbDescriptor ejbDescriptor, boolean isLocal) {
        super(name, "", description);
        this.isLocal = isLocal;
        this.setEjbDescriptor(ejbDescriptor);
    }

    public EjbReferenceDescriptor() {
    }

    public void setReferringBundleDescriptor(BundleDescriptor referringBundle) {
        this.referringBundle = referringBundle;
    }

    public BundleDescriptor getReferringBundleDescriptor() {
        return this.referringBundle;
    }

    public void setEjbDescriptor(EjbDescriptor ejbDescriptor) {
        if (this.ejbDescriptor != null) {
            this.ejbDescriptor.removeEjbReferencer(this);
        }
        this.ejbDescriptor = ejbDescriptor;
        if (ejbDescriptor != null) {
            ejbDescriptor.addEjbReferencer(this);
            if (this.isLocal()) {
                if (!(ejbDescriptor.isLocalInterfacesSupported() || ejbDescriptor.isLocalBusinessInterfacesSupported() || ejbDescriptor.isLocalBean())) {
                    throw new RuntimeException(localStrings.getLocalString("entreprise.deployment.invalidLocalInterfaceReference", "Trying to set an ejb-local-ref on an EJB while the EJB does not define local interfaces"));
                }
            } else if (!ejbDescriptor.isRemoteInterfacesSupported() && !ejbDescriptor.isRemoteBusinessInterfacesSupported()) {
                throw new RuntimeException(localStrings.getLocalString("entreprise.deployment.invalidRemoteInterfaceReference", "Trying to set an ejb-ref on an EJB, while the EJB does not define remote interfaces"));
            }
        }
    }

    public void setJndiName(String jndiName) {
        this.setValue(jndiName);
    }

    public boolean hasJndiName() {
        String name = this.getJndiName();
        return name != null && !name.equals("");
    }

    public boolean isLinked() {
        return this.ejbLink != null;
    }

    public String getLinkName() {
        if (this.ejbDescriptor == null) {
            return this.ejbLink;
        }
        if (this.ejbLink != null && this.ejbLink.length() != 0) {
            return this.ejbLink;
        }
        return this.ejbDescriptor.getName();
    }

    public void setLinkName(String linkName) {
        this.ejbLink = linkName;
    }

    public String getJndiName() {
        String jndiName = this.getValue();
        if (this.isLocal()) {
            return jndiName;
        }
        return jndiName != null && !jndiName.equals("") ? jndiName : this.getMappedName();
    }

    public String getValue() {
        if (this.ejbDescriptor == null) {
            return super.getValue();
        }
        if (this.isLocal()) {
            return super.getValue();
        }
        return this.ejbDescriptor.getJndiName();
    }

    public void setLookupName(String l) {
        this.lookupName = l;
    }

    public String getLookupName() {
        return this.lookupName;
    }

    public boolean hasLookupName() {
        return this.lookupName != null;
    }

    public EjbDescriptor getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean local) {
        this.isLocal = local;
    }

    public String getType() {
        if (this.ejbDescriptor == null) {
            return this.refType;
        }
        return this.ejbDescriptor.getType();
    }

    public void setType(String type) {
        this.refType = type;
    }

    public String getInjectResourceType() {
        return this.isEJB30ClientView() ? this.getEjbInterface() : this.getEjbHomeInterface();
    }

    public void setInjectResourceType(String resourceType) {
        if (this.isEJB30ClientView()) {
            this.setEjbInterface(resourceType);
        } else {
            this.setEjbHomeInterface(resourceType);
        }
    }

    public String getHomeClassName() {
        return this.refHomeIntf;
    }

    public void setHomeClassName(String homeClassName) {
        this.refHomeIntf = homeClassName;
    }

    public String getBeanClassName() {
        return this.refIntf;
    }

    public void setBeanClassName(String remoteClassName) {
        this.refIntf = remoteClassName;
    }

    public String getEjbHomeInterface() {
        return this.getHomeClassName();
    }

    public void setEjbHomeInterface(String homeClassName) {
        this.setHomeClassName(homeClassName);
    }

    public String getEjbInterface() {
        return this.getBeanClassName();
    }

    public void setEjbInterface(String remoteClassName) {
        this.setBeanClassName(remoteClassName);
    }

    public boolean isEJB30ClientView() {
        return this.getHomeClassName() == null;
    }

    public void print(StringBuffer toStringBuffer) {
        String localVsRemote = this.isLocal() ? "Local" : "Remote";
        toStringBuffer.append(localVsRemote + " ejb-ref ");
        toStringBuffer.append("name=" + this.getName());
        if (this.isEJB30ClientView()) {
            toStringBuffer.append("," + localVsRemote + " 3.x interface =" + this.getEjbInterface());
        } else {
            toStringBuffer.append("," + localVsRemote + " 2.x home =" + this.getEjbHomeInterface());
            toStringBuffer.append("," + localVsRemote + " 2.x component interface=" + this.getEjbInterface());
        }
        if (this.ejbDescriptor != null) {
            toStringBuffer.append(" resolved to intra-app EJB " + this.ejbDescriptor.getName() + " in module " + this.ejbDescriptor.getEjbBundleDescriptor().getModuleName());
        }
        toStringBuffer.append(",ejb-link=" + this.getLinkName());
        toStringBuffer.append(",lookup=" + this.getLookupName());
        toStringBuffer.append(",mappedName=" + this.getMappedName());
        toStringBuffer.append(",jndi-name=" + this.getValue());
        toStringBuffer.append(",refType=" + this.getType());
    }

    public boolean equals(Object object) {
        if (object instanceof EjbReference) {
            EjbReference ejbReference = (EjbReference)object;
            return ejbReference.getName().equals(this.getName());
        }
        return false;
    }
}

