/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.node.DataSourcePropertyNode;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceDefinitionNode
extends DeploymentDescriptorNode<DataSourceDefinitionDescriptor> {
    public static final XMLElement tag = new XMLElement("data-source");
    private DataSourceDefinitionDescriptor descriptor = null;

    public DataSourceDefinitionNode() {
        this.registerElementHandler(new XMLElement("property"), DataSourcePropertyNode.class, "addDataSourcePropertyDescriptor");
    }

    @Override
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("description", "setDescription");
        table.put("name", "setName");
        table.put("class-name", "setClassName");
        table.put("server-name", "setServerName");
        table.put("port-number", "setPortNumber");
        table.put("database-name", "setDatabaseName");
        table.put("url", "setUrl");
        table.put("user", "setUser");
        table.put("password", "setPassword");
        table.put("login-timeout", "setLoginTimeout");
        table.put("transactional", "setTransactional");
        table.put("isolation-level", "setIsolationLevel");
        table.put("initial-pool-size", "setInitialPoolSize");
        table.put("max-pool-size", "setMaxPoolSize");
        table.put("min-pool-size", "setMinPoolSize");
        table.put("max-idle-time", "setMaxIdleTime");
        table.put("max-statements", "setMaxStatements");
        return table;
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, DataSourceDefinitionDescriptor dataSourceDesc) {
        Element node = DataSourceDefinitionNode.appendChild(parent, nodeName);
        DataSourceDefinitionNode.appendTextChild((Node)node, "description", dataSourceDesc.getDescription());
        DataSourceDefinitionNode.appendTextChild((Node)node, "name", dataSourceDesc.getName());
        DataSourceDefinitionNode.appendTextChild((Node)node, "class-name", dataSourceDesc.getClassName());
        DataSourceDefinitionNode.appendTextChild((Node)node, "server-name", dataSourceDesc.getServerName());
        DataSourceDefinitionNode.appendTextChild((Node)node, "port-number", dataSourceDesc.getPortNumber());
        DataSourceDefinitionNode.appendTextChild((Node)node, "database-name", dataSourceDesc.getDatabaseName());
        DataSourceDefinitionNode.appendTextChild((Node)node, "url", dataSourceDesc.getUrl());
        DataSourceDefinitionNode.appendTextChild((Node)node, "user", dataSourceDesc.getUser());
        DataSourceDefinitionNode.appendTextChild((Node)node, "password", dataSourceDesc.getPassword());
        DataSourcePropertyNode propertyNode = new DataSourcePropertyNode();
        propertyNode.writeDescriptor((Node)node, dataSourceDesc);
        DataSourceDefinitionNode.appendTextChild((Node)node, "login-timeout", String.valueOf(dataSourceDesc.getLoginTimeout()));
        DataSourceDefinitionNode.appendTextChild((Node)node, "transactional", String.valueOf(dataSourceDesc.isTransactional()));
        String isolationLevelString = dataSourceDesc.getIsolationLevelString();
        if (isolationLevelString != null) {
            DataSourceDefinitionNode.appendTextChild((Node)node, "isolation-level", isolationLevelString);
        }
        DataSourceDefinitionNode.appendTextChild((Node)node, "initial-pool-size", dataSourceDesc.getInitialPoolSize());
        DataSourceDefinitionNode.appendTextChild((Node)node, "max-pool-size", dataSourceDesc.getMaxPoolSize());
        DataSourceDefinitionNode.appendTextChild((Node)node, "min-pool-size", dataSourceDesc.getMinPoolSize());
        DataSourceDefinitionNode.appendTextChild((Node)node, "max-idle-time", String.valueOf(dataSourceDesc.getMaxIdleTime()));
        DataSourceDefinitionNode.appendTextChild((Node)node, "max-statements", dataSourceDesc.getMaxStatements());
        return node;
    }

    @Override
    public DataSourceDefinitionDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new DataSourceDefinitionDescriptor();
        }
        return this.descriptor;
    }
}

