/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl.reader;

import com.sun.jersey.json.impl.reader.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class JsonLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int STRING = 1;
    public static final int YYINITIAL = 0;
    private static final String ZZ_CMAP_PACKED = "\b\u0000\u0002\u0001\u0001\u0019\u0002\u0000\u0001\u0019\u0012\u0000\u0001\u0001\u0001\u0000\u0001\u0017\b\u0000\u0001\u0007\u0001\b\u0001\u0002\u0001\u0005\u0001\u001a\u0001\u0003\t\u0004\u0001\t\u0006\u0000\u0004\u001c\u0001\u0006\u0001\u001c\u0014\u0000\u0001\n\u0001\u0018\u0001\u000b\u0003\u0000\u0001\u0013\u0001\u001b\u0002\u001c\u0001\u0011\u0001\u0012\u0005\u0000\u0001\u0014\u0001\u0000\u0001\u0016\u0003\u0000\u0001\u000f\u0001\u0015\u0001\u000e\u0001\u0010\u0005\u0000\u0001\f\u0001\u0000\u0001\r\uff82\u0000";
    private static final char[] ZZ_CMAP = JsonLexer.zzUnpackCMap("\b\u0000\u0002\u0001\u0001\u0019\u0002\u0000\u0001\u0019\u0012\u0000\u0001\u0001\u0001\u0000\u0001\u0017\b\u0000\u0001\u0007\u0001\b\u0001\u0002\u0001\u0005\u0001\u001a\u0001\u0003\t\u0004\u0001\t\u0006\u0000\u0004\u001c\u0001\u0006\u0001\u001c\u0014\u0000\u0001\n\u0001\u0018\u0001\u000b\u0003\u0000\u0001\u0013\u0001\u001b\u0002\u001c\u0001\u0011\u0001\u0012\u0005\u0000\u0001\u0014\u0001\u0000\u0001\u0016\u0003\u0000\u0001\u000f\u0001\u0015\u0001\u000e\u0001\u0010\u0005\u0000\u0001\f\u0001\u0000\u0001\r\uff82\u0000");
    private static final int[] ZZ_ACTION = JsonLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0001\u0001\u0001\u0000\u0002\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0003\u0000\u0001\t\u0001\n\u0001\u000b\u0006\u0000\u0001\f\u0001\r\u0001\u0000\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0001\u0014\u0001\u0000\u0001\u0015\u0001\u0000\u0001\u0016\u0001\u0000\u0001\u0017";
    private static final int[] ZZ_ROWMAP = JsonLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u001d\u0000:\u0000W\u0000t\u0000\u0091\u0000:\u0000:\u0000:\u0000:\u0000:\u0000:\u0000\u00ae\u0000\u00cb\u0000\u00e8\u0000:\u0000\u0105\u0000:\u0000\u0122\u0000\u013f\u0000\u015c\u0000\u0179\u0000\u0196\u0000\u01b3\u0000:\u0000:\u0000\u01d0\u0000:\u0000:\u0000:\u0000:\u0000:\u0000:\u0000\u01ed\u0000\u020a\u0000\u020a\u0000\u0227\u0000\u0244\u0000\u0261\u0000\u027e\u0000:\u0000\u029b\u0000:\u0000\u02b8\u0000:\u0000\u02d5\u0000:";
    private static final int[] ZZ_TRANS = JsonLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0000\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0003\u0000\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0003\u0000\u0001\u000e\u0003\u0000\u0001\u000f\u0001\u0010\u0001\u0000\u0001\u0003\u0003\u0000\u0017\u0011\u0001\u0012\u0001\u0013\u0001\u0000\u0003\u0011 \u0000\u0001\u0005\u0001\u0006\u001d\u0000\u0001\u0014\u0001\u0015\n\u0000\u0001\u0015\u000e\u0000\u0002\u0006\u0001\u0014\u0001\u0015\n\u0000\u0001\u0015\u001a\u0000\u0001\u0016 \u0000\u0001\u0017\u0019\u0000\u0001\u0018\f\u0000\u0017\u0011\u0003\u0000\u0003\u0011\u000e\u0000\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u0000\u0001\u001c\u0003\u0000\u0001\u001d\u0001\u001e\u0001\u001f\u0001\u0000\u0001 \u0001!\u0004\u0000\u0002\"\u001a\u0000\u0001#\u0002$\u0002\u0000\u0001#%\u0000\u0001% \u0000\u0001&\u001c\u0000\u0001'\u000b\u0000\u0002(\u0001\u0000\u0001(\n\u0000\u0003(\u0007\u0000\u0002(\u0003\u0000\u0002\"\u0001\u0000\u0001\u0015\n\u0000\u0001\u0015\u000e\u0000\u0002$)\u0000\u0001) \u0000\u0001*\u001b\u0000\u0001+\u000b\u0000\u0002,\u0001\u0000\u0001,\n\u0000\u0003,\u0007\u0000\u0002,\u0011\u0000\u0001-\u000e\u0000\u0002.\u0001\u0000\u0001.\n\u0000\u0003.\u0007\u0000\u0002.\u0003\u0000\u0002/\u0001\u0000\u0001/\n\u0000\u0003/\u0007\u0000\u0002/";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = JsonLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0001\t\u0001\u0000\u0002\u0001\u0006\t\u0003\u0000\u0001\t\u0001\u0001\u0001\t\u0006\u0000\u0002\t\u0001\u0000\u0006\t\u0001\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\t\u0001\u0000\u0001\t\u0001\u0000\u0001\t\u0001\u0000\u0001\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    StringBuffer string = new StringBuffer();

    private static int[] zzUnpackAction() {
        int[] result = new int[47];
        int offset = 0;
        offset = JsonLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[47];
        int offset = 0;
        offset = JsonLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[754];
        int offset = 0;
        offset = JsonLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[47];
        int offset = 0;
        offset = JsonLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public int getCharOffset() {
        return this.yychar;
    }

    public int getLineNumber() {
        return this.yyline;
    }

    public int getColumn() {
        return this.yycolumn;
    }

    JsonLexer(Reader in) {
        this.zzReader = in;
    }

    JsonLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 92) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public JsonToken yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block52: while (true) {
            int zzInput;
            int zzCurrentPosL;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            boolean zzR = false;
            block53: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; ++zzCurrentPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        zzR = false;
                        continue block53;
                    }
                    case '\r': {
                        ++this.yyline;
                        zzR = true;
                        continue block53;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            continue block53;
                        }
                        ++this.yyline;
                        continue block53;
                    }
                    default: {
                        zzR = false;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    boolean eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 23: {
                    this.string.append(Character.toChars(Integer.parseInt(this.yytext().substring(2), 16)));
                }
                case 24: {
                    continue block52;
                }
                case 15: {
                    this.string.append('\n');
                }
                case 25: {
                    continue block52;
                }
                case 6: {
                    return new JsonToken(4, this.yytext(), this.yyline, this.yychar, this.yychar + 1);
                }
                case 26: {
                    continue block52;
                }
                case 7: {
                    return new JsonToken(1, this.yytext(), this.yyline, this.yychar, this.yychar + 1);
                }
                case 27: {
                    continue block52;
                }
                case 3: {
                    return new JsonToken(6, this.yytext(), this.yyline, this.yychar, this.yychar + 1);
                }
                case 28: {
                    continue block52;
                }
                case 4: {
                    return new JsonToken(5, this.yytext(), this.yyline, this.yychar, this.yychar + 1);
                }
                case 29: {
                    continue block52;
                }
                case 19: {
                    this.string.append('\b');
                }
                case 30: {
                    continue block52;
                }
                case 8: {
                    return new JsonToken(2, this.yytext(), this.yyline, this.yychar, this.yychar + 1);
                }
                case 31: {
                    continue block52;
                }
                case 21: {
                    return new JsonToken(11, this.yytext(), this.yyline, this.yychar, this.yychar + this.yylength());
                }
                case 32: {
                    continue block52;
                }
                case 18: {
                    this.string.append('/');
                }
                case 33: {
                    continue block52;
                }
                case 17: {
                    this.string.append('\\');
                }
                case 34: {
                    continue block52;
                }
                case 22: {
                    return new JsonToken(10, this.yytext(), this.yyline, this.yychar, this.yychar + this.yylength());
                }
                case 35: {
                    continue block52;
                }
                case 9: {
                    this.string.setLength(0);
                    this.yybegin(1);
                }
                case 36: {
                    continue block52;
                }
                case 11: {
                    this.yybegin(0);
                    return new JsonToken(7, this.string.toString(), this.yyline, this.yychar, this.yychar + this.string.length());
                }
                case 37: {
                    continue block52;
                }
                case 2: {
                    return new JsonToken(8, this.yytext(), this.yyline, this.yychar, this.yychar + this.yylength());
                }
                case 38: {
                    continue block52;
                }
                case 20: {
                    return new JsonToken(9, this.yytext(), this.yyline, this.yychar, this.yychar + this.yylength());
                }
                case 39: {
                    continue block52;
                }
                case 13: {
                    this.string.append('\r');
                }
                case 40: {
                    continue block52;
                }
                case 10: {
                    this.string.append(this.yytext());
                }
                case 41: {
                    continue block52;
                }
                case 16: {
                    this.string.append('\"');
                }
                case 42: {
                    continue block52;
                }
                case 14: {
                    this.string.append('\f');
                }
                case 43: {
                    continue block52;
                }
                case 5: {
                    return new JsonToken(3, this.yytext(), this.yyline, this.yychar, this.yychar + 1);
                }
                case 44: {
                    continue block52;
                }
                case 12: {
                    this.string.append('\t');
                }
                case 45: {
                    continue block52;
                }
                case 1: 
                case 46: {
                    continue block52;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }
}

