/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.JavaEEResource;
import com.sun.appserv.connectors.internal.api.ResourcePropertyImpl;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.resource.beans.CustomResource;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=Singleton.class)
public class CustomResourceDeployer
implements ResourceDeployer {
    private static final StringManager localStrings = StringManager.getManager(CustomResourceDeployer.class);
    @Inject
    private GlassfishNamingManager namingMgr;
    private static Logger _logger = LogDomains.getLogger(CustomResourceDeployer.class, (String)"javax.enterprise.system.core");

    public synchronized void deployResource(Object resource) throws Exception {
        com.sun.enterprise.config.serverbeans.CustomResource customRes = (com.sun.enterprise.config.serverbeans.CustomResource)resource;
        if (ConnectorsUtil.parseBoolean((String)customRes.getEnabled())) {
            JavaEEResource j2eeResource = CustomResourceDeployer.toCustomJavaEEResource(customRes);
            this.installCustomResource((CustomResource)j2eeResource);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{customRes.getJndiName(), "custom"});
        }
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        com.sun.enterprise.config.serverbeans.CustomResource customRes = (com.sun.enterprise.config.serverbeans.CustomResource)resource;
        JavaEEResource j2eeResource = CustomResourceDeployer.toCustomJavaEEResource(customRes);
        this.namingMgr.unpublishObject(j2eeResource.getName());
    }

    public boolean handles(Object resource) {
        return resource instanceof com.sun.enterprise.config.serverbeans.CustomResource;
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public void installCustomResource(CustomResource customRes) {
        String bindName = null;
        try {
            bindName = customRes.getName();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "installCustomResource by jndi-name : " + bindName);
            }
            Reference ref = new Reference(customRes.getResType(), customRes.getFactoryClass(), null);
            for (ResourceProperty prop : customRes.getProperties()) {
                ref.add(new StringRefAddr(prop.getName(), (String)prop.getValue()));
            }
            this.namingMgr.publishObject(bindName, (Object)ref, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error", bindName);
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error_excp", ex);
        }
    }

    public static JavaEEResource toCustomJavaEEResource(com.sun.enterprise.config.serverbeans.CustomResource rbean) {
        CustomResource jr = new CustomResource(rbean.getJndiName());
        jr.setEnabled(ConnectorsUtil.parseBoolean((String)rbean.getEnabled()));
        jr.setResType(rbean.getResType());
        jr.setFactoryClass(rbean.getFactoryClass());
        List properties = rbean.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                ResourcePropertyImpl rp = new ResourcePropertyImpl(property.getName(), (Object)property.getValue());
                jr.addProperty((ResourceProperty)rp);
            }
        }
        return jr;
    }
}

