/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.listener;

import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.Profiler;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public final class GenericJavaConfigListener
implements PostConstruct,
ConfigListener {
    @Inject
    JavaConfig jc;
    volatile List<String> oldProps;
    volatile Map<String, String> oldAttrs;
    @Inject
    Logger logger;
    private static final String SYS_PROP_REGEX = "=";
    static final String DPREFIX = "-D";

    public void postConstruct() {
        if (this.jc != null && this.jc.getJvmOptions() != null) {
            this.oldProps = new ArrayList<String>(this.jc.getJvmOptions());
            this.oldAttrs = GenericJavaConfigListener.collectAttrs(this.jc);
        }
    }

    private static final Map<String, String> collectAttrs(JavaConfig jc) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("JavaHome", jc.getJavaHome());
        values.put("DebugEnabled", jc.getDebugEnabled());
        values.put("DebugOptions", jc.getDebugOptions());
        values.put("RmicOptions", jc.getRmicOptions());
        values.put("JavacOptions", jc.getJavacOptions());
        values.put("ClasspathPrefix", jc.getClasspathPrefix());
        values.put("ClasspathSuffix", jc.getClasspathSuffix());
        values.put("ServerClasspath", jc.getServerClasspath());
        values.put("SystemClasspath", jc.getSystemClasspath());
        values.put("NativeLibraryPathPrefix", jc.getNativeLibraryPathPrefix());
        values.put("NativeLibraryPathSuffix", jc.getNativeLibraryPathSuffix());
        values.put("BytecodePreprocessors", jc.getBytecodePreprocessors());
        values.put("EnvClasspathIgnored", jc.getEnvClasspathIgnored());
        return values;
    }

    @Override
    public synchronized UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        UnprocessedChangeEvents unp = ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tc, T t) {
                NotProcessed result = null;
                if (t instanceof Profiler) {
                    result = new NotProcessed("Creation or changes to a profiler require restart");
                } else if (t instanceof Property) {
                    result = new NotProcessed("Addition of properties to JavaConfig requires restart");
                } else if (t instanceof JavaConfig) {
                    JavaConfig njc = (JavaConfig)t;
                    GenericJavaConfigListener.this.logFine(type, njc);
                    ArrayList<String> curProps = new ArrayList<String>(njc.getJvmOptions());
                    boolean jvmOptionsWereChanged = !((Object)GenericJavaConfigListener.this.oldProps).equals(curProps);
                    List reasons = GenericJavaConfigListener.this.handle(GenericJavaConfigListener.this.oldProps, curProps);
                    GenericJavaConfigListener.this.oldProps = curProps;
                    Map curAttrs = GenericJavaConfigListener.collectAttrs(njc);
                    reasons.addAll(GenericJavaConfigListener.this.handleAttrs(GenericJavaConfigListener.this.oldAttrs, curAttrs));
                    GenericJavaConfigListener.this.oldAttrs = curAttrs;
                    result = reasons.size() == 0 ? null : new NotProcessed(GenericJavaConfigListener.toString(reasons));
                } else {
                    throw new IllegalArgumentException("Unknown interface: " + tc.getName());
                }
                return result;
            }
        }, this.logger);
        return unp;
    }

    private void logFine(Changed.TYPE ct, JavaConfig njc) {
        Level level = Level.FINE;
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, "<java-config> changed");
            int os = this.oldProps.size();
            int ns = njc.getJvmOptions().size();
            if (os > ns) {
                this.logger.log(level, "a system property or a JVM option was removed (old size = " + os + "), new size: (" + ns + "), restart is required, based on the property");
            } else if (os < ns) {
                this.logger.log(level, "a system property or a JVM option was added, (old size = " + os + "), new size: (" + ns + "), restart is required, based on the property");
            } else {
                this.logger.log(level, "an attribute was changed, restart required");
            }
        }
    }

    private List<String> handleAttrs(Map<String, String> old, Map<String, String> cur) {
        if (old.size() != cur.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> reasons = new ArrayList<String>();
        for (String key : old.keySet()) {
            String oldValue = old.get(key);
            String curValue = cur.get(key);
            boolean changed = oldValue == null && curValue != null || oldValue != null && curValue == null || oldValue != null && !oldValue.equals(curValue);
            if (!changed) continue;
            reasons.add("JavaConfig attribute '" + key + "' was changed from '" + oldValue + "' to '" + curValue + "'");
        }
        return reasons;
    }

    private List<String> handle(List<String> old, List<String> cur) {
        Object np = null;
        HashSet<String> added = new HashSet<String>(cur);
        added.removeAll(old);
        HashSet<String> removed = new HashSet<String>(old);
        removed.removeAll(cur);
        return this.getNotProcessed(removed, added);
    }

    private String[] nvp(String s) {
        String[] nv = s.split(SYS_PROP_REGEX);
        String name = nv[0];
        String value = s.substring(name.length());
        if (value.startsWith(SYS_PROP_REGEX)) {
            value = value.substring(1);
        }
        return new String[]{name, value};
    }

    private static String stripPrefix(String s) {
        return s.startsWith(DPREFIX) ? s.substring(DPREFIX.length()) : s;
    }

    private List<String> getNotProcessed(Set<String> removals, Set<String> additions) {
        String name;
        String[] nv;
        ArrayList<String> reasons = new ArrayList<String>();
        for (String removed : removals) {
            nv = this.nvp(removed);
            name = nv[0];
            if (this.possiblyDynamicallyReconfigurable(removed)) {
                System.clearProperty(GenericJavaConfigListener.stripPrefix(name));
                continue;
            }
            String newItem = null;
            for (String added : additions) {
                if (!name.equals(this.nvp(added)[0])) continue;
                newItem = added;
                additions.remove(added);
                break;
            }
            String msg = null;
            msg = newItem != null ? "Change from '" + removed + "' to '" + newItem + "' cannot take effect without server restart" : "Removal of: " + removed + " cannot take effect without server restart";
            reasons.add(msg);
        }
        for (String added : additions) {
            nv = this.nvp(added);
            name = nv[0];
            String newValue = nv[1];
            if (this.possiblyDynamicallyReconfigurable(added)) {
                System.setProperty(GenericJavaConfigListener.stripPrefix(name), newValue);
                continue;
            }
            reasons.add("Addition of: '" + added + "' cannot take effect without server restart");
        }
        return reasons;
    }

    private static String toString(List<String> items) {
        StringBuffer buf = new StringBuffer();
        String delim = ", ";
        for (String s : items) {
            if (buf.length() != 0) {
                buf.append(", ");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    private boolean possiblyDynamicallyReconfigurable(String s) {
        return s.startsWith(DPREFIX) && !s.startsWith("-Djava.") && !s.startsWith("-Djavax.");
    }
}

