/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.history.DecoratedDatabaseTable;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataExpression
extends BaseExpression {
    protected Vector derivedTables;
    protected Vector derivedFields;
    protected boolean hasBeenNormalized = false;
    protected TableAliasLookup tableAliases;
    protected AsOfClause asOfClause;

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        DataExpression expression = (DataExpression)object;
        return (this.getBaseExpression() == expression.getBaseExpression() || this.getBaseExpression() != null && this.getBaseExpression().equals(expression.getBaseExpression())) && (this.getAsOfClause() == expression.getAsOfClause() || this.getAsOfClause() != null && this.getAsOfClause().equals(expression.getAsOfClause()));
    }

    private void addAdditionalTablesToTableList(Vector tableList) {
        if (this.getAdditionalTables() != null) {
            for (DatabaseTable table : this.getAdditionalTables()) {
                if (tableList.contains(table)) continue;
                tableList.add(table);
            }
        }
    }

    public void addDerivedField(Expression addThis) {
        if (this.derivedFields == null) {
            this.derivedFields = NonSynchronizedVector.newInstance(4);
        }
        this.derivedFields.addElement(addThis);
    }

    public void addDerivedTable(Expression addThis) {
        if (this.derivedTables == null) {
            this.derivedTables = NonSynchronizedVector.newInstance(4);
        }
        this.derivedTables.addElement(addThis);
    }

    @Override
    public Expression asOf(AsOfClause clause) {
        this.asOfClause = clause;
        return this;
    }

    @Override
    public DatabaseTable aliasForTable(DatabaseTable table) {
        if (this.tableAliases == null) {
            if (this.getBaseExpression() == null) {
                return null;
            }
            return this.getBaseExpression().aliasForTable(table);
        }
        return this.tableAliases.keyAtValue(table);
    }

    @Override
    protected void assignAlias(String name, DatabaseTable table) {
        if (!this.getBuilder().getSession().getProject().hasGenericHistorySupport()) {
            this.assignAlias(new DecoratedDatabaseTable(name, this.getAsOfClause()), table);
        } else {
            this.assignAlias(new DatabaseTable(name), table);
        }
    }

    protected void assignAlias(DatabaseTable alias, DatabaseTable table) {
        if (this.tableAliases == null) {
            this.tableAliases = new TableAliasLookup();
        }
        this.tableAliases.put(alias, table);
    }

    public void clearAliases() {
        this.tableAliases = null;
    }

    public Vector copyCollection(Vector in, Map alreadyDone) {
        if (in == null) {
            return null;
        }
        NonSynchronizedVector result = NonSynchronizedVector.newInstance(in.size());
        Enumeration e = in.elements();
        while (e.hasMoreElements()) {
            Expression exp = (Expression)e.nextElement();
            ((Vector)result).addElement(exp.copiedVersionFrom(alreadyDone));
        }
        return result;
    }

    public Expression existingDerivedField(DatabaseField field) {
        if (this.derivedFields == null) {
            return null;
        }
        Enumeration e = this.derivedFields.elements();
        while (e.hasMoreElements()) {
            FieldExpression exp = (FieldExpression)e.nextElement();
            if (!exp.getField().equals(field)) continue;
            return exp;
        }
        return null;
    }

    public Expression existingDerivedTable(DatabaseTable table) {
        if (this.derivedTables == null) {
            return null;
        }
        Enumeration e = this.derivedTables.elements();
        while (e.hasMoreElements()) {
            TableExpression exp = (TableExpression)e.nextElement();
            if (!exp.getTable().equals(table)) continue;
            return exp;
        }
        return null;
    }

    public DatabaseField getAliasedField() {
        return null;
    }

    @Override
    public AsOfClause getAsOfClause() {
        return this.asOfClause;
    }

    public ClassDescriptor getDescriptor() {
        return null;
    }

    public DatabaseField getField() {
        return null;
    }

    @Override
    public Expression getField(String fieldName) {
        DatabaseField field = new DatabaseField(fieldName);
        return this.getField(field);
    }

    @Override
    public Expression getField(DatabaseField field) {
        Expression existing = this.existingDerivedField(field);
        if (existing != null) {
            return existing;
        }
        return this.newDerivedField(field);
    }

    public DatabaseMapping getMapping() {
        if (this.getBaseExpression() == null) {
            return null;
        }
        ClassDescriptor aDescriptor = ((DataExpression)this.getBaseExpression()).getDescriptor();
        if (aDescriptor == null) {
            return null;
        }
        return aDescriptor.getObjectBuilder().getMappingForAttributeName(this.getName());
    }

    @Override
    public Vector getOwnedTables() {
        if (this.getDescriptor() == null) {
            if (this.getAdditionalTables() != null) {
                Vector tables = new Vector();
                this.addAdditionalTablesToTableList(tables);
                return tables;
            }
            return null;
        }
        if (this.getDescriptor().isAggregateDescriptor()) {
            return null;
        }
        if (this.getDescriptor().getHistoryPolicy() != null && this.getAsOfClause().getValue() != null) {
            return this.getDescriptor().getHistoryPolicy().getHistoricalTables();
        }
        Vector<DatabaseTable> tables = new Vector<DatabaseTable>();
        tables.addAll(this.getDescriptor().getTables());
        this.addAdditionalTablesToTableList(tables);
        return tables;
    }

    public List<DatabaseTable> getAdditionalTables() {
        return null;
    }

    public QueryKey getQueryKeyOrNull() {
        return null;
    }

    @Override
    public Expression getTable(String tableName) {
        DatabaseTable table = new DatabaseTable(tableName);
        return this.getTable(table);
    }

    @Override
    public Expression getTable(DatabaseTable table) {
        Expression existing = this.existingDerivedTable(table);
        if (existing != null) {
            return existing;
        }
        return this.newDerivedTable(table);
    }

    @Override
    public TableAliasLookup getTableAliases() {
        return this.tableAliases;
    }

    public boolean hasBeenNormalized() {
        return this.hasBeenNormalized;
    }

    @Override
    public boolean hasAsOfClause() {
        return this.getAsOfClause() != null && this.getAsOfClause().getValue() != null;
    }

    @Override
    public boolean hasBeenAliased() {
        return this.tableAliases != null && this.tableAliases.size() != 0;
    }

    protected boolean hasDerivedFields() {
        return this.derivedFields != null;
    }

    protected boolean hasDerivedTables() {
        return this.derivedTables != null;
    }

    public boolean isAttribute() {
        return false;
    }

    @Override
    public boolean isDataExpression() {
        return true;
    }

    @Override
    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        if (this.baseExpression != null) {
            this.baseExpression.iterateOn(iterator);
        }
    }

    public Expression mappingCriteria() {
        return null;
    }

    public Expression newDerivedField(DatabaseField field) {
        FieldExpression result = new FieldExpression(field, this);
        this.addDerivedField(result);
        return result;
    }

    public Expression newDerivedTable(DatabaseTable table) {
        TableExpression result = new TableExpression(table);
        result.setBaseExpression(this);
        this.addDerivedTable(result);
        return result;
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.getBaseExpression() != null) {
            this.setBaseExpression(this.getBaseExpression().normalize(normalizer));
            if (this.getAsOfClause() == null) {
                this.asOf(this.getBaseExpression().getAsOfClause());
            }
        }
        return super.normalize(normalizer);
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.clearAliases();
        this.derivedFields = this.copyCollection(this.derivedFields, alreadyDone);
        this.derivedTables = this.copyCollection(this.derivedTables, alreadyDone);
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        printer.printField(this.getAliasedField());
    }

    public void setHasBeenNormalized(boolean value) {
        this.hasBeenNormalized = value;
    }

    public void setTableAliases(TableAliasLookup tableAliases) {
        if (this.tableAliases == null) {
            this.tableAliases = tableAliases;
        }
    }

    public String tableAliasesDescription() {
        if (this.tableAliases == null) {
            return "";
        }
        return this.tableAliases.toString();
    }

    @Override
    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.getBaseExpression() != null) {
            this.getBaseExpression().toString(writer, indent);
        }
    }
}

