/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.expressions.ForUpdateOfClause;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedSubVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ContainerIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.NoIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.UnitOfWorkQueryValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.indirection.WeavedObjectBasicIndirectionPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public abstract class ForeignReferenceMapping
extends DatabaseMapping {
    protected Class referenceClass;
    protected String referenceClassName;
    protected transient AbstractSession tempInitSession;
    protected transient ClassDescriptor referenceDescriptor;
    protected transient ReadQuery selectionQuery;
    protected boolean isPrivateOwned = false;
    protected boolean usesBatchReading = false;
    protected IndirectionPolicy indirectionPolicy;
    protected transient boolean hasCustomSelectionQuery = false;
    protected DatabaseMapping relationshipPartner;
    protected String relationshipPartnerAttributeName;
    protected boolean cascadePersist;
    protected boolean cascadeMerge;
    protected boolean cascadeRefresh;
    protected boolean cascadeRemove;
    protected boolean cascadeDetach;
    protected boolean requiresTransientWeavedFields;
    protected int joinFetch = 0;
    public static final int INNER_JOIN = 1;
    public static final int OUTER_JOIN = 2;
    public static final int NONE = 0;
    protected boolean forceInitializationOfSelectionCriteria;
    ExtendPessimisticLockScope extendPessimisticLockScope;

    protected ForeignReferenceMapping() {
        this.useBasicIndirection();
        this.cascadePersist = false;
        this.cascadeMerge = false;
        this.cascadeRefresh = false;
        this.cascadeRemove = false;
        this.requiresTransientWeavedFields = true;
        this.forceInitializationOfSelectionCriteria = false;
        this.extendPessimisticLockScope = ExtendPessimisticLockScope.NONE;
    }

    protected Object batchedValueFromRow(AbstractRecord row, ReadAllQuery query) {
        ReadQuery batchQuery = (ReadQuery)query.getProperty(this);
        if (batchQuery == null) {
            if (query.getBatchReadMappingQueries() != null) {
                batchQuery = (ReadQuery)query.getBatchReadMappingQueries().get(this);
            }
            if (batchQuery == null) {
                batchQuery = this.prepareNestedBatchQuery(query);
                batchQuery.setIsExecutionClone(true);
            } else {
                batchQuery = (ReadQuery)batchQuery.clone();
                batchQuery.setIsExecutionClone(true);
            }
            query.setProperty(this, batchQuery);
        }
        return this.indirectionPolicy.valueFromBatchQuery(batchQuery, row, query);
    }

    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        Object attributeValue = this.getAttributeValueFromObject(clone);
        Object clonedAttributeValue = this.indirectionPolicy.backupCloneAttribute(attributeValue, clone, backup, unitOfWork);
        this.setAttributeValueInObject(backup, clonedAttributeValue);
    }

    public abstract Object buildBackupCloneForPartObject(Object var1, Object var2, Object var3, UnitOfWorkImpl var4);

    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        Object clonedAttributeValue = this.indirectionPolicy.cloneAttribute(attributeValue, original, clone, unitOfWork, false);
        this.setAttributeValueInObject(clone, clonedAttributeValue);
    }

    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Object attributeValue = this.valueFromRow(databaseRow, joinManager, sourceQuery, executionSession);
        Object clonedAttributeValue = this.indirectionPolicy.cloneAttribute(attributeValue, null, clone, unitOfWork, true);
        this.setAttributeValueInObject(clone, clonedAttributeValue);
        if (this.isExtendingPessimisticLockScope(sourceQuery) && this.extendPessimisticLockScope == ExtendPessimisticLockScope.TARGET_QUERY) {
            this.indirectionPolicy.instantiateObject(clone, clonedAttributeValue);
        }
    }

    public abstract Object buildCloneForPartObject(Object var1, Object var2, Object var3, UnitOfWorkImpl var4, boolean var5);

    public Object clone() {
        ForeignReferenceMapping clone = (ForeignReferenceMapping)super.clone();
        clone.setIndirectionPolicy((IndirectionPolicy)this.indirectionPolicy.clone());
        clone.setSelectionQuery((ReadQuery)this.getSelectionQuery().clone());
        return clone;
    }

    public abstract Object[] buildReferencesPKList(Object var1, Object var2, AbstractSession var3);

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        if (this.isPrivateOwned()) {
            return this.compareObjectsWithPrivateOwned(firstObject, secondObject, session);
        }
        return this.compareObjectsWithoutPrivateOwned(firstObject, secondObject, session);
    }

    protected abstract boolean compareObjectsWithoutPrivateOwned(Object var1, Object var2, AbstractSession var3);

    protected abstract boolean compareObjectsWithPrivateOwned(Object var1, Object var2, AbstractSession var3);

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.getReferenceClassName() != null) {
            Class referenceClass;
            block7: {
                referenceClass = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            referenceClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader));
                            break block7;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exception.getException());
                        }
                    }
                    referenceClass = PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exc);
                }
            }
            this.setReferenceClass(referenceClass);
        }
        if (this.getSelectionQuery() != null) {
            this.getSelectionQuery().convertClassNamesToClasses(classLoader);
        }
    }

    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface attributeValue, Object original, Object clone, AbstractRecord row, UnitOfWorkImpl unitOfWork, boolean buildDirectlyFromRow) {
        return new UnitOfWorkQueryValueHolder(attributeValue, clone, this, row, unitOfWork);
    }

    protected boolean dontDoMerge(Object target, Object source, MergeManager mergeManager) {
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return true;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy()) {
            if (!this.isAttributeValueInstantiated(target)) {
                return true;
            }
        } else {
            if (mergeManager.shouldRefreshRemoteObject() && this.shouldMergeCascadeParts(mergeManager) && this.usesIndirection()) {
                return true;
            }
            if (!this.isAttributeValueInstantiated(source)) {
                return true;
            }
        }
        return false;
    }

    public void dontUseBatchReading() {
        this.setUsesBatchReading(false);
    }

    public void dontUseIndirection() {
        this.setIndirectionPolicy(new NoIndirectionPolicy());
    }

    protected void extendPessimisticLockScopeInTargetQuery(ObjectLevelReadQuery targetQuery, ObjectBuildingQuery sourceQuery) {
        targetQuery.setLockMode(sourceQuery.getLockMode());
    }

    public void extendPessimisticLockScopeInSourceQuery(ObjectLevelReadQuery sourceQuery) {
    }

    public Object extractResultFromBatchQuery(DatabaseQuery query, AbstractRecord Record2, AbstractSession session, AbstractRecord argumentRow) throws QueryException {
        throw QueryException.batchReadingNotSupported(this, query);
    }

    public ObjectLevelReadQuery prepareNestedJoins(JoinedAttributeManager joinManager, ObjectBuildingQuery baseQuery, AbstractSession session) {
        ObjectLevelReadQuery nestedQuery = (ObjectLevelReadQuery)((ObjectLevelReadQuery)this.getSelectionQuery()).deepClone();
        nestedQuery.setSession(session);
        if (baseQuery.hasPartialAttributeExpressions()) {
            nestedQuery.setPartialAttributeExpressions(this.extractNestedExpressions(((ObjectLevelReadQuery)baseQuery).getPartialAttributeExpressions(), nestedQuery.getExpressionBuilder(), false));
            if (nestedQuery.getPartialAttributeExpressions().isEmpty() && this.hasRootExpressionThatShouldUseOuterJoin(((ObjectLevelReadQuery)baseQuery).getPartialAttributeExpressions())) {
                nestedQuery.setShouldBuildNullForNullPk(true);
            }
        } else {
            Vector nestedJoins = this.extractNestedExpressions(joinManager.getJoinedAttributeExpressions(), nestedQuery.getExpressionBuilder(), false);
            if (nestedJoins.size() > 0) {
                nestedQuery.getJoinedAttributeManager().clear();
                nestedQuery.getJoinedAttributeManager().setJoinedAttributeExpressions_(nestedJoins);
                nestedQuery.getJoinedAttributeManager().prepareJoinExpressions(session);
                nestedQuery.getJoinedAttributeManager().computeJoiningMappingIndexes(true, session, 0);
            } else if (nestedQuery.hasJoining()) {
                nestedQuery.setJoinedAttributeManager(null);
            }
            if (baseQuery.isLockQuery()) {
                if (((ObjectLevelReadQuery)baseQuery).getLockingClause().isForUpdateOfClause()) {
                    ForUpdateOfClause clause = (ForUpdateOfClause)((ObjectLevelReadQuery)baseQuery).getLockingClause().clone();
                    clause.setLockedExpressions(this.extractNestedExpressions(clause.getLockedExpressions(), nestedQuery.getExpressionBuilder(), true));
                    nestedQuery.setLockingClause(clause);
                } else {
                    nestedQuery.setLockingClause(((ObjectLevelReadQuery)baseQuery).getLockingClause());
                }
            }
        }
        nestedQuery.setShouldMaintainCache(baseQuery.shouldMaintainCache());
        nestedQuery.setShouldRefreshIdentityMapResult(baseQuery.shouldRefreshIdentityMapResult());
        if (baseQuery.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)baseQuery).hasAsOfClause()) {
            nestedQuery.setAsOfClause(((ObjectLevelReadQuery)baseQuery).getAsOfClause());
        }
        nestedQuery.setCascadePolicy(baseQuery.getCascadePolicy());
        if (nestedQuery.hasJoining()) {
            nestedQuery.getJoinedAttributeManager().computeJoiningMappingQueries(session);
        }
        nestedQuery.setSession(null);
        return nestedQuery;
    }

    protected void postPrepareNestedBatchQuery(ReadQuery batchQuery, ReadAllQuery query) {
    }

    public ReadQuery prepareNestedBatchQuery(ReadAllQuery query) {
        ReadQuery mappingQuery;
        ReadAllQuery batchQuery = new ReadAllQuery();
        batchQuery.setReferenceClass(this.getReferenceClass());
        batchQuery.setDescriptor(this.getReferenceDescriptor());
        batchQuery.setSession(query.getSession());
        batchQuery.setShouldUseWrapperPolicy(false);
        if (query.shouldCascadeAllParts() || query.shouldCascadePrivateParts() && this.isPrivateOwned() || query.shouldCascadeByMapping() && this.cascadeRefresh) {
            batchQuery.setShouldRefreshIdentityMapResult(query.shouldRefreshIdentityMapResult());
            batchQuery.setCascadePolicy(query.getCascadePolicy());
            batchQuery.setShouldMaintainCache(query.shouldMaintainCache());
            if (query.hasAsOfClause()) {
                batchQuery.setAsOfClause(query.getAsOfClause());
            }
            batchQuery.setShouldBindAllParameters(query.getShouldBindAllParameters());
            batchQuery.setShouldPrepare(query.shouldPrepare());
        }
        batchQuery.setShouldOuterJoinSubclasses(query.shouldOuterJoinSubclasses());
        batchQuery.setQueryId(query.getQueryId());
        ClassDescriptor descriptorToUse = query.getDescriptor();
        if (descriptorToUse != this.getDescriptor() && !descriptorToUse.getMappings().contains(this) && !this.getDescriptor().isAggregateDescriptor()) {
            descriptorToUse = this.getDescriptor();
        }
        ExpressionBuilder builder = batchQuery.getExpressionBuilder();
        Expression backRef = builder.getManualQueryKey(this.getAttributeName() + "-back-ref", descriptorToUse);
        Expression twisted = backRef.twist(this.getSelectionCriteria(), builder);
        if (query.getSelectionCriteria() != null) {
            twisted = twisted.and(query.getSelectionCriteria().cloneUsing(backRef));
        }
        if (descriptorToUse.getQueryManager().getAdditionalJoinExpression() != null) {
            twisted = twisted.and(descriptorToUse.getQueryManager().getAdditionalJoinExpression().rebuildOn(backRef));
        }
        if (descriptorToUse.getHistoryPolicy() != null) {
            if (query.getSession().getAsOfClause() != null) {
                backRef.asOf(query.getSession().getAsOfClause());
            } else if (batchQuery.getAsOfClause() == null) {
                backRef.asOf(AsOfClause.NO_CLAUSE);
            } else {
                backRef.asOf(batchQuery.getAsOfClause());
            }
            twisted = twisted.and(descriptorToUse.getHistoryPolicy().additionalHistoryExpression((ObjectExpression)backRef));
        }
        batchQuery.setSelectionCriteria(twisted);
        if (query.isDistinctComputed()) {
            batchQuery.setDistinctState(query.getDistinctState());
        }
        if ((mappingQuery = this.getSelectionQuery()).isReadAllQuery()) {
            batchQuery.setOrderByExpressions(new ArrayList<Expression>(((ReadAllQuery)mappingQuery).getOrderByExpressions()));
            Enumeration enumtr = ((ReadAllQuery)mappingQuery).getBatchReadAttributeExpressions().elements();
            while (enumtr.hasMoreElements()) {
                Expression expression = ((Expression)enumtr.nextElement()).rebuildOn(batchQuery.getExpressionBuilder());
                batchQuery.addBatchReadAttribute(expression);
            }
        }
        Vector nestedExpressions = this.extractNestedExpressions(query.getBatchReadAttributeExpressions(), batchQuery.getExpressionBuilder(), false);
        Helper.addAllToVector(batchQuery.getBatchReadAttributeExpressions(), nestedExpressions);
        this.postPrepareNestedBatchQuery(batchQuery, query);
        if (batchQuery.shouldPrepare()) {
            batchQuery.checkPrepare(query.getSession(), query.getTranslationRow());
        }
        batchQuery.setSession(null);
        return batchQuery;
    }

    protected Hashtable getBatchReadObjects(DatabaseQuery query, AbstractSession session) {
        if (session.isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)session;
            return (Hashtable)unitOfWork.getBatchReadObjects().get(query);
        }
        return (Hashtable)query.getProperty("batched objects");
    }

    protected void setBatchReadObjects(Hashtable referenceObjectsByKey, DatabaseQuery query, AbstractSession session) {
        if (session.isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)session;
            unitOfWork.getBatchReadObjects().put(query, referenceObjectsByKey);
        } else {
            query.setProperty("batched objects", referenceObjectsByKey);
        }
    }

    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        this.indirectionPolicy.fixObjectReferences(object, objectDescriptors, processedObjects, query, session);
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object attributeValue = super.getAttributeValueFromObject(object);
        Object indirectionValue = this.indirectionPolicy.validateAttributeOfInstantiatedObject(attributeValue);
        if (indirectionValue != attributeValue) {
            this.setAttributeValueInObject(object, indirectionValue);
            attributeValue = indirectionValue;
        }
        return attributeValue;
    }

    public Object getAttributeValueWithClonedValueHolders(Object object) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue instanceof DatabaseValueHolder) {
            return ((DatabaseValueHolder)attributeValue).clone();
        }
        if (attributeValue instanceof ValueHolder) {
            return ((ValueHolder)attributeValue).clone();
        }
        return attributeValue;
    }

    protected ReadQuery getExtendPessimisticLockScopeDedicatedQuery(AbstractSession session, short lockMode) {
        return null;
    }

    public IndirectionPolicy getIndirectionPolicy() {
        return this.indirectionPolicy;
    }

    public Expression getJoinCriteria(QueryKeyExpression exp) {
        Expression selectionCriteria = this.getSelectionCriteria();
        return exp.getBaseExpression().twist(selectionCriteria, exp);
    }

    public Object getObjectCorrespondingTo(Object object, RemoteSession session, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query) {
        return session.getObjectCorrespondingTo(object, objectDescriptors, processedObjects, query);
    }

    public Object getRealAttributeValueFromAttribute(Object attributeValue, Object object, AbstractSession session) {
        return this.indirectionPolicy.getRealAttributeValueFromObject(object, attributeValue);
    }

    public boolean isLazy() {
        if (this.isLazy == null) {
            this.isLazy = this.usesIndirection();
        }
        return this.isLazy;
    }

    public boolean isLockableMapping() {
        return !this.usesIndirection();
    }

    public void instantiateAttribute(Object object, AbstractSession session) {
        this.indirectionPolicy.instantiateObject(object, this.getAttributeValueFromObject(object));
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public ClassDescriptor getReferenceDescriptor() {
        if (this.referenceDescriptor == null) {
            if (this.getTempSession() == null) {
                return null;
            }
            this.referenceDescriptor = this.getTempSession().getDescriptor(this.getReferenceClass());
        }
        return this.referenceDescriptor;
    }

    public DatabaseMapping getRelationshipPartner() {
        if (this.relationshipPartner == null && this.relationshipPartnerAttributeName != null) {
            this.setRelationshipPartner(this.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(this.getRelationshipPartnerAttributeName()));
        }
        return this.relationshipPartner;
    }

    public String getRelationshipPartnerAttributeName() {
        return this.relationshipPartnerAttributeName;
    }

    public Expression getSelectionCriteria() {
        return this.getSelectionQuery().getSelectionCriteria();
    }

    public ReadQuery getSelectionQuery() {
        return this.selectionQuery;
    }

    protected AbstractSession getTempSession() {
        return this.tempInitSession;
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return this.indirectionPolicy.getValueFromRemoteValueHolder(remoteValueHolder);
    }

    public boolean hasCustomSelectionQuery() {
        return this.hasCustomSelectionQuery;
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        Class attributeType;
        super.preInitialize(session);
        if (this.indirectionPolicy instanceof BasicIndirectionPolicy && ClassConstants.PersistenceWeavedLazy_Class.isAssignableFrom(this.getDescriptor().getJavaClass()) && !ClassConstants.ValueHolderInterface_Class.isAssignableFrom(attributeType = this.getAttributeAccessor().getAttributeClass())) {
            boolean usesMethodAccess = this.getAttributeAccessor().isMethodAttributeAccessor();
            String originalSetMethod = null;
            if (usesMethodAccess) {
                originalSetMethod = this.getSetMethodName();
            }
            this.setGetMethodName(Helper.getWeavedValueHolderGetMethodName(this.getAttributeName()));
            this.setSetMethodName(Helper.getWeavedValueHolderSetMethodName(this.getAttributeName()));
            if (usesMethodAccess) {
                this.useWeavedIndirection(originalSetMethod);
            }
            super.preInitialize(session);
        }
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.isPrivateOwned) {
            this.getDescriptor().addMappingsPostCalculateChanges(this);
            if (this.getDescriptor().hasInheritance()) {
                for (ClassDescriptor descriptor : this.getDescriptor().getInheritancePolicy().getAllChildDescriptors()) {
                    descriptor.addMappingsPostCalculateChanges(this);
                }
            }
        }
        this.initializeReferenceDescriptor(session);
        this.initializeSelectionQuery(session);
        this.indirectionPolicy.initialize();
    }

    protected void initializeReferenceDescriptor(AbstractSession session) throws DescriptorException {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ClassDescriptor refDescriptor = session.getDescriptor(this.getReferenceClass());
        if (refDescriptor == null) {
            throw DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this);
        }
        if (refDescriptor.isAggregateDescriptor() && !this.isAggregateCollectionMapping()) {
            throw DescriptorException.referenceDescriptorCannotBeAggregate(this);
        }
        if ((this.getDescriptor() == null || !this.getDescriptor().isIsolated()) && refDescriptor.isIsolated()) {
            throw DescriptorException.isolateDescriptorReferencedBySharedDescriptor(refDescriptor.getJavaClassName(), this.getDescriptor().getJavaClassName(), this);
        }
        this.setReferenceDescriptor(refDescriptor);
    }

    protected void initializeSelectionQuery(AbstractSession session) throws DescriptorException {
        if (((ObjectLevelReadQuery)this.getSelectionQuery()).getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        this.getSelectionQuery().setName(this.getAttributeName());
        this.getSelectionQuery().setDescriptor(this.getReferenceDescriptor());
        this.getSelectionQuery().setSourceMapping(this);
    }

    public boolean isAttributeValueInstantiated(Object object) {
        return this.indirectionPolicy.objectIsInstantiated(this.getAttributeValueFromObject(object));
    }

    public boolean isCascadeDetach() {
        return this.cascadeDetach;
    }

    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    public boolean isCascadeMerge() {
        return this.cascadeMerge;
    }

    public boolean isCascadeRefresh() {
        return this.cascadeRefresh;
    }

    public boolean isCascadeRemove() {
        return this.cascadeRemove;
    }

    public boolean isForeignReferenceMapping() {
        return true;
    }

    public boolean isJoiningSupported() {
        return false;
    }

    public boolean isPrivateOwned() {
        return this.isPrivateOwned;
    }

    public void iterate(DescriptorIterator iterator) {
        Object attributeValue = this.getAttributeValueFromObject(iterator.getVisitedParent());
        this.indirectionPolicy.iterateOnAttributeValue(iterator, attributeValue);
    }

    public abstract void iterateOnRealAttributeValue(DescriptorIterator var1, Object var2);

    public void mergeRemoteValueHolder(Object clientSideDomainObject, Object serverSideDomainObject, MergeManager mergeManager) {
        this.indirectionPolicy.mergeRemoteValueHolder(clientSideDomainObject, serverSideDomainObject, mergeManager);
    }

    public void privateOwnedRelationship() {
        this.setIsPrivateOwned(true);
    }

    public void remoteInitialization(DistributedSession session) {
        super.remoteInitialization(session);
        this.setTempSession(session);
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return controller.replaceValueHoldersIn(object);
    }

    public boolean requiresTransientWeavedFields() {
        return this.requiresTransientWeavedFields;
    }

    public void setCascadeAll(boolean value) {
        this.setCascadePersist(value);
        this.setCascadeMerge(value);
        this.setCascadeRefresh(value);
        this.setCascadeRemove(value);
        this.setCascadeDetach(value);
    }

    public void setCascadeDetach(boolean value) {
        this.cascadeDetach = value;
    }

    public void setCascadePersist(boolean value) {
        this.cascadePersist = value;
    }

    public void setCascadeMerge(boolean value) {
        this.cascadeMerge = value;
    }

    public void setCascadeRefresh(boolean value) {
        this.cascadeRefresh = value;
    }

    public void setCascadeRemove(boolean value) {
        this.cascadeRemove = value;
    }

    public void setCustomSelectionQuery(ReadQuery query) {
        this.setSelectionQuery(query);
        this.setHasCustomSelectionQuery(true);
    }

    protected void setHasCustomSelectionQuery(boolean bool) {
        this.hasCustomSelectionQuery = bool;
    }

    public void setForceInitializationOfSelectionCriteria(boolean bool) {
        this.forceInitializationOfSelectionCriteria = bool;
    }

    public void setIndirectionPolicy(IndirectionPolicy indirectionPolicy) {
        this.indirectionPolicy = indirectionPolicy;
        indirectionPolicy.setMapping(this);
    }

    public void setIsPrivateOwned(boolean isPrivateOwned) {
        if (this.descriptor != null && !this.isMapKeyMapping()) {
            if (isPrivateOwned && !this.isPrivateOwned) {
                this.descriptor.addMappingsPostCalculateChanges(this);
                if (this.getDescriptor().hasInheritance()) {
                    for (ClassDescriptor descriptor : this.getDescriptor().getInheritancePolicy().getAllChildDescriptors()) {
                        descriptor.addMappingsPostCalculateChanges(this);
                    }
                }
            } else if (!isPrivateOwned && this.isPrivateOwned) {
                this.descriptor.getMappingsPostCalculateChanges().remove(this);
                if (this.getDescriptor().hasInheritance()) {
                    for (ClassDescriptor descriptor : this.getDescriptor().getInheritancePolicy().getAllChildDescriptors()) {
                        descriptor.getMappingsPostCalculateChanges().remove(this);
                    }
                }
            }
        }
        this.isPrivateOwned = isPrivateOwned;
    }

    public void setRealAttributeValueInObject(Object object, Object value) throws DescriptorException {
        this.indirectionPolicy.setRealAttributeValueInObject(object, value);
    }

    public void setReferenceClass(Class referenceClass) {
        this.referenceClass = referenceClass;
        if (referenceClass != null) {
            this.setReferenceClassName(referenceClass.getName());
            this.setSelectionQuery(this.getSelectionQuery());
        }
    }

    public void setReferenceClassName(String referenceClassName) {
        this.referenceClassName = referenceClassName;
    }

    protected void setReferenceDescriptor(ClassDescriptor aDescriptor) {
        this.referenceDescriptor = aDescriptor;
    }

    public void setRelationshipPartner(DatabaseMapping mapping) {
        this.relationshipPartner = mapping;
    }

    public void setRelationshipPartnerAttributeName(String attributeName) {
        this.relationshipPartnerAttributeName = attributeName;
    }

    public void setRequiresTransientWeavedFields(boolean requiresTransientWeavedFields) {
        this.requiresTransientWeavedFields = requiresTransientWeavedFields;
    }

    public void setSelectionCriteria(Expression anExpression) {
        this.getSelectionQuery().setSelectionCriteria(anExpression);
    }

    protected void setSelectionQuery(ReadQuery aQuery) {
        this.selectionQuery = aQuery;
        if (this.selectionQuery != null && this.selectionQuery.isObjectLevelReadQuery() && this.selectionQuery.getReferenceClassName() == null) {
            ((ObjectLevelReadQuery)this.selectionQuery).setReferenceClass(this.getReferenceClass());
        }
    }

    public void setSelectionSQLString(String sqlString) {
        this.getSelectionQuery().setSQLString(sqlString);
        this.setCustomSelectionQuery(this.getSelectionQuery());
    }

    public void setSelectionCall(Call call) {
        this.getSelectionQuery().setCall(call);
        this.setCustomSelectionQuery(this.getSelectionQuery());
    }

    public void setShouldExtendPessimisticLockScope(boolean shouldExtend) {
        this.extendPessimisticLockScope = shouldExtend ? ExtendPessimisticLockScope.TARGET_QUERY : ExtendPessimisticLockScope.NONE;
    }

    protected void setTempSession(AbstractSession session) {
        this.tempInitSession = session;
    }

    public void setUsesBatchReading(boolean usesBatchReading) {
        this.usesBatchReading = usesBatchReading;
    }

    public void setUsesIndirection(boolean usesIndirection) {
        if (usesIndirection) {
            this.useBasicIndirection();
        } else {
            this.dontUseIndirection();
        }
    }

    public boolean shouldExtendPessimisticLockScope() {
        return this.extendPessimisticLockScope != ExtendPessimisticLockScope.NONE;
    }

    public boolean shouldExtendPessimisticLockScopeInSourceQuery() {
        return this.extendPessimisticLockScope == ExtendPessimisticLockScope.SOURCE_QUERY;
    }

    public boolean shouldExtendPessimisticLockScopeInTargetQuery() {
        return this.extendPessimisticLockScope == ExtendPessimisticLockScope.TARGET_QUERY;
    }

    public boolean shouldExtendPessimisticLockScopeInDedicatedQuery() {
        return this.extendPessimisticLockScope == ExtendPessimisticLockScope.DEDICATED_QUERY;
    }

    protected boolean shouldForceInitializationOfSelectionCriteria() {
        return this.forceInitializationOfSelectionCriteria;
    }

    protected boolean shouldInitializeSelectionCriteria() {
        if (this.shouldForceInitializationOfSelectionCriteria()) {
            return true;
        }
        if (this.hasCustomSelectionQuery()) {
            return false;
        }
        return this.getSelectionCriteria() == null;
    }

    public boolean shouldMergeCascadeParts(MergeManager mergeManager) {
        return mergeManager.shouldCascadeByMapping() && this.isCascadeMerge() || mergeManager.shouldCascadeAllParts() || mergeManager.shouldCascadePrivateParts() && this.isPrivateOwned();
    }

    protected boolean shouldMergeCascadeReference(MergeManager mergeManager) {
        if (mergeManager.shouldCascadeReferences()) {
            return true;
        }
        return this.shouldMergeCascadeParts(mergeManager);
    }

    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery query) {
        if (this.isReadOnly()) {
            return false;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return this.hasConstraintDependency();
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return query.shouldCascadeAllParts();
    }

    public boolean shouldUseBatchReading() {
        return this.usesBatchReading;
    }

    public void useBasicIndirection() {
        this.setIndirectionPolicy(new BasicIndirectionPolicy());
    }

    public void useBatchReading() {
        this.setUsesBatchReading(true);
    }

    public void useWeavedIndirection(String setMethodName) {
        this.setIndirectionPolicy(new WeavedObjectBasicIndirectionPolicy(setMethodName));
    }

    public void useContainerIndirection(Class containerClass) {
        ContainerIndirectionPolicy policy = new ContainerIndirectionPolicy();
        policy.setContainerClass(containerClass);
        this.setIndirectionPolicy(policy);
    }

    public boolean usesIndirection() {
        return this.indirectionPolicy.usesIndirection();
    }

    public void setJoinFetch(int joinFetch) {
        this.joinFetch = joinFetch;
    }

    public int getJoinFetch() {
        return this.joinFetch;
    }

    public boolean isJoinFetched() {
        return this.getJoinFetch() != 0;
    }

    public boolean isInnerJoinFetched() {
        return this.getJoinFetch() == 1;
    }

    public boolean isOuterJoinFetched() {
        return this.getJoinFetch() == 2;
    }

    public void useInnerJoinFetch() {
        this.setJoinFetch(1);
    }

    public void useOuterJoinFetch() {
        this.setJoinFetch(2);
    }

    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
        super.validateBeforeInitialization(session);
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class attributeType = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.indirectionPolicy.validateDeclaredAttributeType(attributeType, session.getIntegrityChecker());
        } else if (this.getAttributeAccessor().isMethodAttributeAccessor()) {
            Class returnType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.indirectionPolicy.validateGetMethodReturnType(returnType, session.getIntegrityChecker());
            Class parameterType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.indirectionPolicy.validateSetMethodParameterType(parameterType, session.getIntegrityChecker());
        }
    }

    public abstract Object valueFromPKList(Object[] var1, AbstractSession var2);

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        if (sourceQuery.isReadAllQuery() && (((ReadAllQuery)sourceQuery).isAttributeBatchRead(this.descriptor, this.getAttributeName()) || this.usesBatchReading)) {
            return this.batchedValueFromRow(row, (ReadAllQuery)sourceQuery);
        }
        if (this.shouldUseValueFromRowWithJoin(joinManager, sourceQuery)) {
            return this.valueFromRowInternalWithJoin(row, joinManager, sourceQuery, executionSession);
        }
        return this.valueFromRowInternal(row, joinManager, sourceQuery, executionSession);
    }

    protected boolean shouldUseValueFromRowWithJoin(JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery) {
        return joinManager != null && joinManager.isAttributeJoined(this.descriptor, this.getAttributeName()) || sourceQuery.hasPartialAttributeExpressions();
    }

    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        throw ValidationException.mappingDoesNotOverrideValueFromRowInternalWithJoin(Helper.getShortClassName(this.getClass()));
    }

    protected Object valueFromRowInternal(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        ReadQuery targetQuery = this.selectionQuery;
        if (!this.indirectionPolicy.usesIndirection()) {
            if (targetQuery.shouldPrepare()) {
                targetQuery.checkPrepare(executionSession, row);
            }
            targetQuery = (ReadQuery)targetQuery.clone();
            targetQuery.setIsExecutionClone(true);
            targetQuery.setQueryId(sourceQuery.getQueryId());
        }
        if (targetQuery.isObjectLevelReadQuery()) {
            if (sourceQuery.shouldCascadeAllParts() || this.isPrivateOwned && sourceQuery.shouldCascadePrivateParts() || this.cascadeRefresh && sourceQuery.shouldCascadeByMapping()) {
                if (targetQuery == this.selectionQuery) {
                    if (targetQuery.shouldPrepare()) {
                        targetQuery.checkPrepare(executionSession, row);
                    }
                    targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
                    targetQuery.setIsExecutionClone(true);
                }
                ((ObjectLevelReadQuery)targetQuery).setShouldRefreshIdentityMapResult(sourceQuery.shouldRefreshIdentityMapResult());
                targetQuery.setCascadePolicy(sourceQuery.getCascadePolicy());
                if (targetQuery.shouldMaintainCache()) {
                    targetQuery.setShouldMaintainCache(sourceQuery.shouldMaintainCache());
                }
                if (((ObjectLevelReadQuery)sourceQuery).hasAsOfClause()) {
                    targetQuery.setSelectionCriteria((Expression)targetQuery.getSelectionCriteria().clone());
                    ((ObjectLevelReadQuery)targetQuery).setAsOfClause(((ObjectLevelReadQuery)sourceQuery).getAsOfClause());
                }
            }
            if (this.isExtendingPessimisticLockScope(sourceQuery)) {
                if (this.extendPessimisticLockScope == ExtendPessimisticLockScope.TARGET_QUERY) {
                    if (targetQuery == this.selectionQuery) {
                        if (targetQuery.shouldPrepare()) {
                            targetQuery.checkPrepare(executionSession, row);
                        }
                        targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
                        targetQuery.setIsExecutionClone(true);
                    }
                    this.extendPessimisticLockScopeInTargetQuery((ObjectLevelReadQuery)targetQuery, sourceQuery);
                } else if (this.extendPessimisticLockScope == ExtendPessimisticLockScope.DEDICATED_QUERY) {
                    ReadQuery dedicatedQuery = this.getExtendPessimisticLockScopeDedicatedQuery(executionSession, sourceQuery.getLockMode());
                    executionSession.executeQuery((DatabaseQuery)dedicatedQuery, row);
                }
            }
        }
        targetQuery = this.prepareHistoricalQuery(targetQuery, sourceQuery, executionSession);
        return this.indirectionPolicy.valueFromQuery(targetQuery, row, sourceQuery.getSession());
    }

    protected boolean isExtendingPessimisticLockScope(ObjectBuildingQuery sourceQuery) {
        return sourceQuery.isLockQuery() && sourceQuery.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)sourceQuery).shouldExtendPessimisticLockScope();
    }

    protected ReadQuery prepareHistoricalQuery(ReadQuery targetQuery, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) {
        return targetQuery;
    }

    public AbstractRecord trimRowForJoin(AbstractRecord row, JoinedAttributeManager joinManager, AbstractSession executionSession) {
        Object value;
        if (joinManager != null && joinManager.getJoinedMappingIndexes_() != null && (value = joinManager.getJoinedMappingIndexes_().get(this)) != null) {
            return this.trimRowForJoin(row, value, executionSession);
        }
        return row;
    }

    public AbstractRecord trimRowForJoin(AbstractRecord row, Object value, AbstractSession executionSession) {
        int fieldStartIndex;
        if (value instanceof Integer) {
            fieldStartIndex = (Integer)value;
        } else {
            Map map = (Map)value;
            Class cls = this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses() ? this.getDescriptor().getInheritancePolicy().classFromRow(row, executionSession) : this.getDescriptor().getJavaClass();
            fieldStartIndex = (Integer)map.get(cls);
        }
        NonSynchronizedSubVector trimedFields = new NonSynchronizedSubVector(row.getFields(), fieldStartIndex, row.size());
        NonSynchronizedSubVector trimedValues = new NonSynchronizedSubVector(row.getValues(), fieldStartIndex, row.size());
        return new DatabaseRecord(trimedFields, trimedValues);
    }

    protected ObjectLevelReadQuery prepareNestedJoinQueryClone(AbstractRecord row, List dataResults, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) {
        ObjectLevelReadQuery nestedQuery = null;
        if (joinManager == null) {
            nestedQuery = this.prepareNestedJoins(joinManager, sourceQuery, executionSession);
            nestedQuery.setSession(executionSession);
            return nestedQuery;
        }
        if (joinManager.getJoinedMappingQueryClones() == null) {
            joinManager.setJoinedMappingQueryClones(new HashMap(5));
        }
        if ((nestedQuery = joinManager.getJoinedMappingQueryClones().get(this)) == null) {
            if (joinManager.getJoinedMappingQueries_() != null) {
                nestedQuery = joinManager.getJoinedMappingQueries_().get(this);
                nestedQuery = (ObjectLevelReadQuery)nestedQuery.clone();
            } else {
                nestedQuery = this.prepareNestedJoins(joinManager, sourceQuery, executionSession);
            }
            nestedQuery.setSession(executionSession);
            nestedQuery.setQueryId(joinManager.getBaseQuery().getQueryId());
            nestedQuery.setExecutionTime(joinManager.getBaseQuery().getExecutionTime());
            joinManager.getJoinedMappingQueryClones().put(this, nestedQuery);
        }
        if (nestedQuery.hasJoining() && nestedQuery.getJoinedAttributeManager().isToManyJoin()) {
            List<AbstractRecord> nestedDataResults = dataResults;
            if (nestedDataResults == null) {
                Vector sourceKey = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(row, executionSession);
                CacheKey sourceCacheKey = new CacheKey(sourceKey);
                nestedDataResults = joinManager.getDataResultsByPrimaryKey().get(sourceCacheKey);
            }
            nestedDataResults = new ArrayList(nestedDataResults);
            Object indexObject = joinManager.getJoinedMappingIndexes_().get(this);
            for (int index = 0; index < nestedDataResults.size(); ++index) {
                AbstractRecord sourceRow = (AbstractRecord)nestedDataResults.get(index);
                nestedDataResults.set(index, this.trimRowForJoin(sourceRow, indexObject, executionSession));
            }
            nestedQuery.getJoinedAttributeManager().setDataResults(nestedDataResults, executionSession);
        }
        return nestedQuery;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExtendPessimisticLockScope {
        NONE,
        TARGET_QUERY,
        SOURCE_QUERY,
        DEDICATED_QUERY;

    }
}

