/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.transaction.jotm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.transaction.TransactionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.transaction.JTATransactionController;

public class JotmTransactionController
extends JTATransactionController {
    protected static final String TX_CURRENT_FACTORY_CLASS = "org.objectweb.jotm.Current";
    protected static final String TX_CURRENT_FACTORY_METHOD = "getCurrent";
    protected static final String TX_MANAGER_FACTORY_METHOD = "getTransactionManager";

    protected TransactionManager acquireTransactionManager() throws Exception {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                Class clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(TX_CURRENT_FACTORY_CLASS));
                Method method = AccessController.doPrivileged(new PrivilegedGetMethod(clazz, TX_CURRENT_FACTORY_METHOD, null, false));
                Method txMethod = AccessController.doPrivileged(new PrivilegedGetMethod(clazz, TX_MANAGER_FACTORY_METHOD, null, false));
                Object current = AccessController.doPrivileged(new PrivilegedMethodInvoker(method, null, null));
                return (TransactionManager)AccessController.doPrivileged(new PrivilegedMethodInvoker(txMethod, current, null));
            }
            catch (PrivilegedActionException ex) {
                if (ex.getCause() instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)ex.getCause();
                }
                if (ex.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)ex.getCause();
                }
                if (ex.getCause() instanceof IllegalAccessException) {
                    throw (IllegalAccessException)ex.getCause();
                }
                if (ex.getCause() instanceof InvocationTargetException) {
                    throw (InvocationTargetException)ex.getCause();
                }
                throw (RuntimeException)ex.getCause();
            }
        }
        Class clazz = PrivilegedAccessHelper.getClassForName(TX_CURRENT_FACTORY_CLASS);
        Method method = PrivilegedAccessHelper.getMethod(clazz, TX_CURRENT_FACTORY_METHOD, null, false);
        Method txMethod = PrivilegedAccessHelper.getMethod(clazz, TX_MANAGER_FACTORY_METHOD, null, false);
        Object current = PrivilegedAccessHelper.invokeMethod(method, null, null);
        return (TransactionManager)PrivilegedAccessHelper.invokeMethod(txMethod, current, null);
    }
}

