/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.constraints.impl;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalMinValidatorForString
implements ConstraintValidator<DecimalMin, String> {
    private BigDecimal minValue;

    @Override
    public void initialize(DecimalMin minValue) {
        try {
            this.minValue = new BigDecimal(minValue.value());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(minValue.value() + " does not represent a valid BigDecimal format");
        }
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        try {
            return new BigDecimal(value).compareTo(this.minValue) != -1;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

