/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Set;
import javax.validation.ValidationException;
import org.hibernate.validator.engine.ConstraintTree;
import org.hibernate.validator.engine.GlobalExecutionContext;
import org.hibernate.validator.engine.LocalExecutionContext;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaConstraint<T, A extends Annotation> {
    private final Member member;
    private final String propertyName;
    private final Class<T> beanClass;
    private final ConstraintTree<A> constraintTree;

    public MetaConstraint(Class<T> beanClass, Member member, ConstraintDescriptorImpl<A> constraintDescriptor) {
        this.member = member;
        if (this.member != null) {
            this.propertyName = ReflectionHelper.getPropertyName(member);
            if (member instanceof Method && this.propertyName == null) {
                throw new ValidationException("Annotated methods must follow the JavaBeans naming convention. " + member.getName() + "() does not.");
            }
        } else {
            this.propertyName = null;
        }
        this.beanClass = beanClass;
        this.constraintTree = new ConstraintTree<A>(constraintDescriptor);
    }

    public Set<Class<?>> getGroupList() {
        return this.constraintTree.getDescriptor().getGroups();
    }

    public ConstraintDescriptorImpl<A> getDescriptor() {
        return this.constraintTree.getDescriptor();
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public Member getMember() {
        return this.member;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public ElementType getElementType() {
        return this.constraintTree.getDescriptor().getElementType();
    }

    public <T, U, V> boolean validateConstraint(GlobalExecutionContext<T> executionContext, LocalExecutionContext<U, V> localExecutionContext) {
        ArrayList constraintViolations = new ArrayList();
        localExecutionContext.setElementType(this.getElementType());
        this.constraintTree.validateConstraints(this.typeOfAnnotatedElement(), executionContext, localExecutionContext, constraintViolations);
        if (constraintViolations.size() > 0) {
            executionContext.addConstraintFailures(constraintViolations);
            return false;
        }
        return true;
    }

    public Object getValue(Object o) {
        switch (this.getElementType()) {
            case TYPE: {
                return o;
            }
        }
        return ReflectionHelper.getValue(this.member, o);
    }

    private Type typeOfAnnotatedElement() {
        Type t;
        switch (this.getElementType()) {
            case TYPE: {
                t = this.beanClass;
                break;
            }
            default: {
                t = ReflectionHelper.typeOf(this.member);
                if (!(t instanceof Class) || !((Class)t).isPrimitive()) break;
                t = ReflectionHelper.boxedType(t);
            }
        }
        return t;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetaConstraint");
        sb.append("{beanClass=").append(this.beanClass);
        sb.append(", member=").append(this.member);
        sb.append(", propertyName='").append(this.propertyName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

