/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.appclient.server.core.jws.CombinedXPath;
import org.glassfish.appclient.server.core.jws.XPathToDeveloperProvidedContentRefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientJNLPConfigData {
    private static final String CONFIG_FILE_NAME = "client-jnlp-config.properties";
    private File previousConfigFileUsed = null;
    private File configFileFromDomain;
    private File configFileFromInstall;
    private long lastModified = -1L;
    private Logger logger = LogDomains.getLogger(ClientJNLPConfigData.class, (String)"javax.enterprise.system.container.appclient");
    private List<XPathToDeveloperProvidedContentRefs> xPathsToDevContentRefs = Collections.EMPTY_LIST;
    private List<CombinedXPath> xPathsToCombinedContent = Collections.EMPTY_LIST;

    ClientJNLPConfigData(File installConfigDir, File domainConfigDir) {
        this.configFileFromInstall = new File(installConfigDir, CONFIG_FILE_NAME);
        this.configFileFromDomain = new File(domainConfigDir, CONFIG_FILE_NAME);
        this.ensureCurrent();
    }

    private void ensureCurrent() {
        File configFile = this.chooseConfigFile();
        if (configFile == null) {
            this.lastModified = -1L;
            this.xPathsToDevContentRefs = Collections.EMPTY_LIST;
            this.xPathsToCombinedContent = Collections.EMPTY_LIST;
            return;
        }
        if (this.lastModified < configFile.lastModified() || this.previousConfigFileUsed != configFile) {
            this.processConfigFile(configFile);
        }
    }

    private File chooseConfigFile() {
        File result = this.checkExistenceAndReadability(this.configFileFromDomain, Level.WARNING);
        if (result == null && (result = this.checkExistenceAndReadability(this.configFileFromInstall, Level.SEVERE)) == null && !this.configFileFromInstall.exists()) {
            this.logErrorNonExistentConfig(this.configFileFromInstall);
        }
        if (result != null && this.previousConfigFileUsed != null && result != this.previousConfigFileUsed) {
            this.logUsingDifferentConfigFile(result);
        }
        return result;
    }

    private File checkExistenceAndReadability(File f, Level logLevel) {
        File result = null;
        if (f.exists()) {
            if (f.canRead()) {
                result = f;
            } else {
                this.logErrorConfigExistsButCannotRead(logLevel, f);
            }
        }
        return result;
    }

    private void logErrorConfigExistsButCannotRead(Level level, File f) {
        this.logger.log(level, "enterprise.deployment.appclient.jws.clientJNLPConfigFileUnreadable", f.getAbsolutePath());
    }

    private void logErrorNonExistentConfig(File f) {
        this.logger.log(Level.SEVERE, "enterprise.deployment.appclient.jws.clientJNLPConfigFileMissing", f.getAbsolutePath());
    }

    private void logUsingDifferentConfigFile(File f) {
        this.logger.log(Level.FINE, "enterprise.deployment.appclient.jws.clientJNLPConfigChangeFile", f.getAbsolutePath());
    }

    List<XPathToDeveloperProvidedContentRefs> xPathsToDevContentRefs() {
        this.ensureCurrent();
        return this.xPathsToDevContentRefs;
    }

    List<CombinedXPath> xPathsToCombinedContent() {
        this.ensureCurrent();
        return this.xPathsToCombinedContent;
    }

    private void processConfigFile(File configFile) {
        Properties p = new Properties();
        try {
            p.load(new BufferedInputStream(new FileInputStream(configFile)));
            List<XPathToDeveloperProvidedContentRefs> newRefsToContent = this.prepareRefsToContent(p);
            List<CombinedXPath> newCombinedXPaths = this.prepareCombinedXPaths(p);
            this.xPathsToDevContentRefs = newRefsToContent;
            this.xPathsToCombinedContent = newCombinedXPaths;
            this.lastModified = configFile.lastModified();
            this.previousConfigFileUsed = configFile;
            this.logger.log(Level.FINE, "enterprise.deployment.appclient.jws.clientJNLPConfigLoad", configFile.getAbsolutePath());
        }
        catch (Exception e) {
            String fmt = this.logger.getResourceBundle().getString("enterprise.deployment.appclient.jws.clientJNLPConfigProcError");
            String msg = MessageFormat.format(fmt, configFile.getAbsolutePath());
            this.logger.log(Level.SEVERE, msg, e);
        }
    }

    private List<XPathToDeveloperProvidedContentRefs> prepareRefsToContent(Properties p) {
        List<XPathToDeveloperProvidedContentRefs> result = XPathToDeveloperProvidedContentRefs.parse(p);
        return result;
    }

    private List<CombinedXPath> prepareCombinedXPaths(Properties p) {
        List<CombinedXPath> result = CombinedXPath.parse(p);
        return result;
    }
}

