/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.model.metadata;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.jboss.interceptor.model.metadata.ArrayIterator;
import org.jboss.interceptor.model.metadata.ClassReference;
import org.jboss.interceptor.model.metadata.ImmutableIteratorWrapper;
import org.jboss.interceptor.model.metadata.MethodReference;
import org.jboss.interceptor.model.metadata.ReflectiveMethodReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveClassReference
implements ClassReference,
Serializable {
    private Class<?> clazz;

    private ReflectiveClassReference(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static ClassReference of(Class<?> clazz) {
        return new ReflectiveClassReference(clazz);
    }

    @Override
    public String getClassName() {
        return this.clazz.getName();
    }

    @Override
    public Iterable<MethodReference> getDeclaredMethods() {
        return new Iterable<MethodReference>(){

            @Override
            public Iterator<MethodReference> iterator() {
                return new ImmutableIteratorWrapper<Method>(new ArrayIterator<Method>(ReflectiveClassReference.this.clazz.getDeclaredMethods())){

                    @Override
                    protected MethodReference wrapObject(Method method) {
                        return ReflectiveMethodReference.of(method);
                    }
                };
            }
        };
    }

    @Override
    public Class<?> getJavaClass() {
        return this.clazz;
    }

    @Override
    public ClassReference getSuperclass() {
        Class<?> superClass = this.clazz.getSuperclass();
        return superClass == null ? null : new ReflectiveClassReference(superClass);
    }
}

