/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-admin-object")
@Scoped(value=PerLookup.class)
@I18n(value="delete.admin.ojbect")
public class DeleteAdminObject
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteAdminObject.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;
    @Inject
    AdminObjectResource[] adminObjectResources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (this.jndiName == null) {
            report.setMessage(localStrings.getLocalString("delete.admin.object.noJndiName", "No JNDI name defined for administered object."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!this.isResourceExists(this.resources, this.jndiName)) {
            report.setMessage(localStrings.getLocalString("delete.admin.object.notfound", "An administered object named {0} does not exist.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            if (ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (AdminObjectResource resource : DeleteAdminObject.this.adminObjectResources) {
                        if (!resource.getJndiName().equals(DeleteAdminObject.this.jndiName)) continue;
                        return param.getResources().remove(resource);
                    }
                    return null;
                }
            }, this.resources) == null) {
                report.setMessage(localStrings.getLocalString("delete.admin.object.fail", "Unable to delete administered object {0}", new Object[]{this.jndiName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            targetServer.deleteResourceRef(this.jndiName);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.admin.object.fail", "Unable to delete administered object {0}", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("delete.admin.object.success", "Administered object {0} deleted", new Object[]{this.jndiName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isResourceExists(Resources resources, String jndiName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof AdminObjectResource) || !((AdminObjectResource)resource).getJndiName().equals(jndiName)) continue;
            return true;
        }
        return false;
    }
}

