/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.base.sfsb.initialization.SFSBTxStoreManagerFactory;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManagerException;
import com.sun.ejb.spi.sfsb.store.SFSBTxStoreManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SFSBTxCheckpointCoordinator {
    private static final Logger _logger = LogDomains.getLogger(SFSBTxCheckpointCoordinator.class, (String)"javax.enterprise.system.container.ejb");
    private String haStoreType;
    private ArrayList ctxList = new ArrayList();

    SFSBTxCheckpointCoordinator(String haStoreType) {
        this.haStoreType = haStoreType;
    }

    void registerContext(SessionContextImpl ctx) {
        this.ctxList.add(ctx);
    }

    void doTxCheckpoint() {
        StatefulSessionContainer container;
        SessionContextImpl ctx;
        int i;
        SessionContextImpl[] contexts = this.ctxList.toArray(new SessionContextImpl[0]);
        int size = contexts.length;
        ArrayList<SFSBBeanState> states = new ArrayList<SFSBBeanState>(size);
        for (i = 0; i < size; ++i) {
            ctx = contexts[i];
            container = (StatefulSessionContainer)ctx.getContainer();
            SFSBBeanState beanState = container.getSFSBBeanState(ctx);
            if (beanState == null) continue;
            states.add(beanState);
        }
        if (states.size() > 0) {
            SFSBBeanState[] beanStates = states.toArray(new SFSBBeanState[0]);
            try {
                SFSBTxStoreManager txStoreManager = SFSBTxStoreManagerFactory.createSFSBTxStoreManager(this.haStoreType);
                txStoreManager.checkpointSave(beanStates);
            }
            catch (SFSBStoreManagerException sfsbEx) {
                _logger.log(Level.WARNING, "Exception during checkpointSave", sfsbEx);
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "Exception during checkpointSave", th);
            }
        }
        for (i = 0; i < size; ++i) {
            ctx = contexts[i];
            container = (StatefulSessionContainer)ctx.getContainer();
            container.txCheckpointCompleted(ctx);
        }
    }
}

