/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.CommonTasksGroup;
import com.sun.webui.jsf.component.CommonTasksSection;
import com.sun.webui.jsf.component.HelpInline;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonTasksSectionRenderer
extends AbstractRenderer {
    private static final String SPACER_IMAGE = "_spacerImg";
    private static final String WHITE_SPACE = "&nbsp;";
    private static final String COLUMN_COUNT = "commonTasks.columnCount";
    private static final String SECTION_TITLE = "commonTasks.sectionTitle";

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String title;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        CommonTasksSection cts = (CommonTasksSection)component;
        Theme theme = ThemeUtilities.getTheme(context);
        int numColumns = 2;
        if (cts.getColumns() > 0) {
            numColumns = cts.getColumns();
        }
        writer.write("\n");
        writer.startElement("div", (UIComponent)cts);
        writer.writeAttribute("id", (Object)cts.getClientId(context), "id");
        String styles = RenderingUtilities.getStyleClasses(context, (UIComponent)cts, theme.getStyleClass("CTS_SECTION"));
        if (styles != null) {
            writer.writeAttribute("class", (Object)styles, "class");
        }
        if ((styles = cts.getStyle()) != null) {
            writer.writeAttribute("style", (Object)styles, "style");
        }
        writer.startElement("table", (UIComponent)cts);
        writer.writeAttribute("width", (Object)"100%", "width");
        writer.writeAttribute("border", (Object)"0", "border");
        writer.writeAttribute("cellpadding", (Object)"0", "cellpadding");
        writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
        writer.writeAttribute("title", (Object)"", "title");
        if (cts.getTitle() != null) {
            title = cts.getTitle();
        } else {
            title = theme.getMessage(SECTION_TITLE);
            cts.setTitle(title);
        }
        writer.write("\n");
        this.renderHeading(title, writer, cts, theme, context);
        writer.endElement("table");
        writer.startElement("table", (UIComponent)cts);
        writer.writeAttribute("width", (Object)"100%", "width");
        writer.writeAttribute("border", (Object)"0", "border");
        writer.writeAttribute("cellpadding", (Object)"0", "cellpadding");
        writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
        writer.writeAttribute("title", (Object)"", "title");
        writer.write("\n");
        this.renderSpacer(writer, (UIComponent)cts, theme, numColumns, context);
        writer.startElement("tr", (UIComponent)cts);
        writer.startElement("td", (UIComponent)cts);
        writer.writeAttribute("valign", (Object)"top", "valign");
        this.layoutCommonTasks(cts, theme, context, writer, numColumns);
        writer.endElement("td");
        writer.startElement("td", (UIComponent)cts);
        writer.writeAttribute("height", (Object)"503", "height");
        this.renderSpacerImage((UIComponent)cts, 503, 1, theme, context);
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void renderJavascript(Theme theme, ResponseWriter writer, UIComponent component, FacesContext context) throws IOException {
        block2: {
            try {
                JSONObject json = new JSONObject();
                json.put("id", (Object)component.getClientId(context)).put("pic1URL", (Object)theme.getImagePath("CTS_RIGHT_TOGGLE_SELECTED")).put("pic2URL", (Object)theme.getImagePath("CTS_RIGHT_TOGGLE_OVER")).put("pic3URL", (Object)theme.getImagePath("CTS_RIGHT_TOGGLE"));
                StringBuffer buff = new StringBuffer();
                buff.append(JavaScriptUtilities.getModule("commonTasksSection")).append("\n").append(JavaScriptUtilities.getModuleName("commonTasksSection.init(")).append(json.toString(4)).append(");\n");
                JavaScriptUtilities.renderJavaScript(component, writer, buff.toString());
            }
            catch (JSONException e) {
                if (!LogUtil.fineEnabled()) break block2;
                LogUtil.fine(e.getStackTrace().toString());
            }
        }
        writer.write("\n");
    }

    protected void renderHeading(String title, ResponseWriter writer, CommonTasksSection cts, Theme theme, FacesContext context) throws IOException {
        writer.startElement("tr", (UIComponent)cts);
        writer.writeAttribute("valign", (Object)"top", "valign");
        writer.startElement("td", (UIComponent)cts);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_TOP_BOX"), "class");
        writer.writeAttribute("colspan", (Object)"4", "colspan");
        writer.writeAttribute("height", (Object)"64", "height");
        writer.startElement("div", (UIComponent)cts);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_HEADER"), "class");
        writer.write(title);
        writer.endElement("div");
        UIComponent comp = cts.getHelp(context);
        if (!(comp instanceof HelpInline)) {
            writer.startElement("div", (UIComponent)cts);
            writer.writeAttribute("class", (Object)theme.getStyleClass("CTS_SECTION_HELP"), "class");
            RenderingUtilities.renderComponent(comp, context);
            writer.endElement("div");
        } else {
            ((HelpInline)comp).setStyleClass(theme.getStyleClass("CTS_SECTION_HELP"));
            RenderingUtilities.renderComponent(comp, context);
        }
        writer.endElement("td");
        writer.endElement("tr");
    }

    protected void renderSpacer(ResponseWriter writer, UIComponent cts, Theme theme, int numColumns, FacesContext context) throws IOException {
        int _spacerWidth = 40;
        int columnWidth = 200;
        int _sepWidth = 9;
        int _initWidth = 5;
        if (numColumns > 1) {
            _spacerWidth /= numColumns - 1;
            columnWidth /= numColumns - 1;
            _sepWidth /= numColumns - 1;
            _initWidth /= numColumns - 1;
        }
        String spacerWidth = "" + _spacerWidth + "%";
        String sepWidth = "" + _sepWidth + "%";
        String initWidth = "" + _initWidth + "%";
        writer.startElement("tr", cts);
        if (numColumns == 1) {
            numColumns = 2;
        }
        for (int i = 0; i < numColumns; ++i) {
            writer.startElement("td", cts);
            writer.writeAttribute("width", (Object)spacerWidth, "width");
            this.renderSpacerImage(cts, 1, columnWidth, theme, context);
            writer.endElement("td");
            writer.startElement("td", cts);
            if (i == numColumns - 1) {
                writer.writeAttribute("width", (Object)initWidth, "width");
            } else {
                writer.writeAttribute("width", (Object)sepWidth, "width");
            }
            writer.write(WHITE_SPACE);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    protected void renderSpacerImage(UIComponent component, int height, int width, Theme theme, FacesContext context) throws IOException {
        Icon img = ThemeUtilities.getIcon(theme, "CTS_SPACER_IMAGE");
        img.setParent(component);
        img.setId(SPACER_IMAGE);
        RenderingUtilities.renderComponent((UIComponent)img, context);
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void layoutCommonTasks(CommonTasksSection cts, Theme theme, FacesContext context, ResponseWriter writer, int numColumns) throws IOException {
        List children = cts.getChildren();
        Iterator itr = children.iterator();
        int commonTaskCount = cts.getCommonTaskCount();
        int cnt = numColumns;
        int separator = (int)Math.ceil((double)commonTaskCount / (double)numColumns);
        int count = 0;
        this.renderJavascript(theme, writer, (UIComponent)cts, context);
        while (itr.hasNext()) {
            Object obj = itr.next();
            UIComponent comp = (UIComponent)obj;
            if (cts.getCommonTaskCount() <= numColumns && count > 0) {
                writer.endElement("td");
                writer.startElement("td", (UIComponent)cts);
                writer.write(WHITE_SPACE);
                writer.endElement("td");
                writer.startElement("td", (UIComponent)cts);
                writer.writeAttribute("valign", (Object)"top", "valign");
            } else if ((count >= separator || comp instanceof CommonTasksGroup && count + ((CommonTasksGroup)comp).getChildCount() > separator && count > 0) && cnt > 1) {
                --cnt;
                writer.endElement("td");
                writer.startElement("td", (UIComponent)cts);
                writer.write(WHITE_SPACE);
                writer.endElement("td");
                writer.startElement("td", (UIComponent)cts);
                writer.writeAttribute("valign", (Object)"top", "valign");
                int tmp = numColumns - 1;
                separator = (int)Math.ceil((double)(commonTaskCount - count) / (double)tmp);
                count = 0;
            }
            RenderingUtilities.renderComponent(comp, context);
            if (comp instanceof CommonTasksGroup) {
                count += comp.getChildCount();
                continue;
            }
            ++count;
        }
    }
}

