/*
 * Decompiled with CFR 0.152.
 */
package pkg.sun.servicetag;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JOptionPane;
import pkg.sun.servicetag.BrowserSupport;
import pkg.sun.servicetag.Installer;
import pkg.sun.servicetag.RegistrationData;
import pkg.sun.servicetag.Util;

class SunConnection {
    private static String JAVADB_REGISTRATION_URL = "https://inventory.sun.com/RegistrationWeb/register";
    private static String SANDBOX_TESTING_URL = "https://connection-tst.sun.com/RegistrationWeb/register";
    private static String SVCTAG_REGISTER_TESTING = "servicetag.register.testing";
    private static String SVCTAG_REGISTRATION_URL = "servicetag.registration.url";
    private static String SVCTAG_CONNECTION_TIMEOUT = "servicetag.connection.timeout";

    private SunConnection() {
    }

    static URL getRegistrationURL(String string) {
        String string2 = System.getProperty(SVCTAG_REGISTRATION_URL);
        if (string2 == null) {
            string2 = System.getProperty(SVCTAG_REGISTER_TESTING) != null ? SANDBOX_TESTING_URL : JAVADB_REGISTRATION_URL;
        }
        if ((string2 = string2.trim()).length() == 0) {
            throw new InternalError("Empty registration url set");
        }
        String string3 = SunConnection.rewriteURL(string2, string);
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            InternalError internalError = new InternalError(malformedURLException.getMessage());
            internalError.initCause(malformedURLException);
            throw internalError;
        }
    }

    private static String rewriteURL(String string, String string2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string.trim());
        if (stringBuilder.charAt((n = stringBuilder.length()) - 1) != '/') {
            stringBuilder.append('/');
        }
        stringBuilder.append(string2);
        stringBuilder.append("?");
        stringBuilder.append("product=javadb");
        stringBuilder.append("&");
        stringBuilder.append("locale=").append(Locale.getDefault().getLanguage());
        return stringBuilder.toString();
    }

    public static void register(RegistrationData registrationData) throws IOException {
        URL uRL = SunConnection.getRegistrationURL(registrationData.getRegistrationURN());
        boolean bl = SunConnection.postRegistrationData(uRL, registrationData);
        if (bl) {
            SunConnection.openURL(uRL.toString());
        } else {
            System.out.println("Check internet connection: cannot reach Sun Registration Relay Service");
        }
    }

    public static void openURL(String string) {
        String string2 = "Error attempting to launch web browser";
        String string3 = System.getProperty("os.name");
        try {
            if (string3.startsWith("Mac OS")) {
                Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                Method method = clazz.getDeclaredMethod("openURL", String.class);
                method.invoke(null, string);
            } else if (string3.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
            } else {
                String[] stringArray = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String string4 = null;
                for (int i = 0; i < stringArray.length && string4 == null; ++i) {
                    if (Runtime.getRuntime().exec(new String[]{"which", stringArray[i]}).waitFor() != 0) continue;
                    string4 = stringArray[i];
                }
                if (string4 == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{string4, string});
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, string2 + ":\n" + exception.getLocalizedMessage());
        }
    }

    private static void openBrowser(URL uRL) throws IOException {
        block5: {
            System.out.println(BrowserSupport.isSupported());
            try {
                BrowserSupport.browse(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                InternalError internalError = new InternalError("Error in registering: " + uRISyntaxException.getMessage());
                internalError.initCause(uRISyntaxException);
                throw internalError;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (Util.isVerbose()) {
                    illegalArgumentException.printStackTrace();
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!Util.isVerbose()) break block5;
                unsupportedOperationException.printStackTrace();
            }
        }
    }

    private static boolean postRegistrationData(URL uRL, RegistrationData registrationData) {
        try {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setUseCaches(false);
            httpsURLConnection.setAllowUserInteraction(false);
            String string = System.getProperty(SVCTAG_CONNECTION_TIMEOUT, "10");
            httpsURLConnection.setConnectTimeout(Util.getIntValue(string) * 1000);
            if (Util.isVerbose()) {
                System.out.println("Connecting to post registration data at " + uRL);
            }
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setRequestProperty("Content-Type", "text/xml;charset=\"utf-8\"");
            httpsURLConnection.connect();
            OutputStream outputStream = httpsURLConnection.getOutputStream();
            registrationData.storeToXML(outputStream);
            outputStream.flush();
            outputStream.close();
            int n = httpsURLConnection.getResponseCode();
            if (Util.isVerbose()) {
                System.out.println("POST return status = " + n);
                SunConnection.printReturnData(httpsURLConnection, n);
            }
            return n == 200;
        }
        catch (MalformedURLException malformedURLException) {
            InternalError internalError = new InternalError("Error in registering: " + malformedURLException.getMessage());
            internalError.initCause(malformedURLException);
            throw internalError;
        }
        catch (Exception exception) {
            if (Util.isVerbose()) {
                exception.printStackTrace();
            }
            return false;
        }
    }

    private static void openOfflineRegisterPage() throws IOException {
        block7: {
            if (!BrowserSupport.isSupported()) {
                if (Util.isVerbose()) {
                    System.out.println("Browser is not supported");
                }
                return;
            }
            File file = Installer.getRegistrationHtmlPage();
            try {
                BrowserSupport.browse(file.toURI());
            }
            catch (FileNotFoundException fileNotFoundException) {
                InternalError internalError = new InternalError("Error in launching " + file + ": " + fileNotFoundException.getMessage());
                internalError.initCause(fileNotFoundException);
                throw internalError;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (Util.isVerbose()) {
                    illegalArgumentException.printStackTrace();
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (!Util.isVerbose()) break block7;
                unsupportedOperationException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printReturnData(HttpURLConnection httpURLConnection, int n) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = n < 400 ? new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream())) : new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
            System.out.println("Response is : ");
            System.out.println(stringBuilder.toString());
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }
}

