/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.util.uuid.UuidGenerator;
import com.sun.enterprise.web.BasePersistenceStrategyBuilder;
import com.sun.enterprise.web.PESessionLocker;
import com.sun.enterprise.web.PESessionLockingStandardPipeline;
import com.sun.enterprise.web.ServerConfigLookup;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.SessionLocker;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardManager;

public class MemoryStrategyBuilder
extends BasePersistenceStrategyBuilder {
    public void initializePersistenceStrategy(Context ctx, SessionManager smBean, ServerConfigLookup serverConfigLookup) {
        super.initializePersistenceStrategy(ctx, smBean, serverConfigLookup);
        String persistenceType = "memory";
        String ctxPath = ctx.getPath();
        if (ctxPath != null && !ctxPath.equals("")) {
            Object[] params = new Object[]{ctx.getPath(), persistenceType};
            _logger.log(Level.FINE, "webcontainer.noPersistence", params);
        }
        StandardManager mgr = new StandardManager();
        if (this.sessionFilename == null) {
            mgr.setPathname(this.sessionFilename);
        } else {
            mgr.setPathname(this.prependContextPathTo(this.sessionFilename, ctx));
        }
        StandardContext sctx = (StandardContext)ctx;
        sctx.restrictedSetPipeline((Pipeline)new PESessionLockingStandardPipeline((Container)sctx));
        mgr.setMaxActiveSessions(this.maxSessions);
        mgr.setSessionLocker((SessionLocker)new PESessionLocker(ctx));
        ctx.setManager((Manager)mgr);
        if (this.sessionIdGeneratorClassname != null && this.sessionIdGeneratorClassname.length() > 0) {
            try {
                UuidGenerator generator = (UuidGenerator)serverConfigLookup.loadClass(this.sessionIdGeneratorClassname).newInstance();
                mgr.setUuidGenerator(generator);
            }
            catch (Exception ex) {
                String msg = _rb.getString("webcontainer.unableLoadSessionUUIdGenerator");
                msg = MessageFormat.format(msg, this.sessionIdGeneratorClassname);
                _logger.log(Level.SEVERE, msg, ex);
            }
        }
        if (!sctx.isSessionTimeoutOveridden()) {
            mgr.setMaxInactiveInterval(this.sessionMaxInactiveInterval);
        }
    }
}

