/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.scripting.jruby.JRubyApplication;
import org.glassfish.scripting.jruby.JRubyConfigImpl;
import org.glassfish.scripting.jruby.JRubyContainer;
import org.glassfish.scripting.jruby.Messages;
import org.glassfish.scripting.jruby.config.JrubyContainer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class JRubyDeployer
implements Deployer<JRubyContainer, JRubyApplication> {
    @Inject
    ServerEnvironment env;
    @Inject
    RequestDispatcher dispatcher;
    @Inject
    JrubyContainer config;
    private String appName;
    private final Logger logger = Logger.getLogger(JRubyContainer.class.getName());

    public boolean prepare(DeploymentContext context) {
        return true;
    }

    public <T> T loadMetaData(Class<T> type, DeploymentContext context) {
        return null;
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, null);
    }

    public JRubyApplication load(JRubyContainer container, DeploymentContext context) {
        String railsRoot;
        this.appName = ((DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class)).name;
        try {
            railsRoot = context.getSourceDir().getCanonicalPath();
        }
        catch (IOException e) {
            railsRoot = context.getSourceDir().getAbsolutePath();
        }
        String contextRoot = this.getContextRoot(context, this.env.getStartupContext().getArguments());
        JRubyConfigImpl jrubyConfig = new JRubyConfigImpl(context.getModuleProps(), ((DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class)).name, railsRoot, contextRoot, this.logger, this.config);
        try {
            return new JRubyApplication(context, this.env, this.dispatcher, container, jrubyConfig);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public void unload(JRubyApplication container, DeploymentContext context) {
        try {
            if (container != null) {
                this.dispatcher.unregisterEndpoint(container.getContextRoot(), (ApplicationContainer)container);
            }
            container = null;
            this.logger.info(Messages.format("jrubydeployer.unloading.info", this.appName));
        }
        catch (EndpointRegistrationException e) {
            this.logger.log(Level.SEVERE, Messages.format("jrubydeployer.unload.err", container.getContextRoot()), e);
        }
    }

    public void clean(DeploymentContext context) {
    }

    private String getContextRoot(DeploymentContext context, Properties props) {
        DeployCommandParameters params = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        String contextRoot = params.contextroot;
        if (contextRoot == null || contextRoot.length() == 0) {
            contextRoot = "/" + params.name;
        }
        if (contextRoot.charAt(0) != '/') {
            contextRoot = "/" + contextRoot;
        }
        return contextRoot;
    }
}

