/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.util.proxy.ProxyFactory;
import org.glassfish.weld.ACLSingletonProvider;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.api.helpers.TCCLSingletonProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class WeldActivator
implements BundleActivator {
    private Logger logger = Logger.getLogger(WeldActivator.class.getName());
    private ProxyFactory.ClassLoaderProvider oldCLP;

    public void start(BundleContext context) throws Exception {
        boolean earSupport = false;
        try {
            Class.forName("org.glassfish.javaee.full.deployment.EarClassLoader");
            earSupport = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        SingletonProvider.initialize((SingletonProvider)(earSupport ? new ACLSingletonProvider() : new TCCLSingletonProvider()));
        this.oldCLP = ProxyFactory.classLoaderProvider;
        ProxyFactory.classLoaderProvider = new GlassFishClassLoaderProvider();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("javassist.util.proxy.ProxyFactory.classLoaderProvider = " + ProxyFactory.classLoaderProvider);
        }
    }

    public void stop(BundleContext context) throws Exception {
        SingletonProvider.reset();
        ProxyFactory.classLoaderProvider = this.oldCLP;
    }

    private static class GlassFishClassLoaderProvider
    implements ProxyFactory.ClassLoaderProvider {
        private GlassFishClassLoaderProvider() {
        }

        public ClassLoader get(ProxyFactory proxyFactory) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

