/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.io.IOException;
import java.util.Enumeration;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service(name="weld")
@Scoped(value=Singleton.class)
public class WeldSniffer
extends GenericSniffer
implements Sniffer {
    private static final String[] containers = new String[]{"org.glassfish.weld.WeldContainer"};
    private static char SEPARATOR_CHAR = (char)47;
    private static final String WEB_INF = "WEB-INF";
    private static final String WEB_INF_LIB = "WEB-INF" + SEPARATOR_CHAR + "lib";
    private static final String WEB_INF_BEANS_XML = "WEB-INF" + SEPARATOR_CHAR + "beans.xml";
    private static final String META_INF_BEANS_XML = "META-INF" + SEPARATOR_CHAR + "beans.xml";
    private static final String JAR_SUFFIX = ".jar";
    private static final String EXPANDED_JAR_SUFFIX = "_jar";

    public WeldSniffer() {
        super("weld", null, null);
    }

    public boolean handles(ReadableArchive archive, ClassLoader loader) {
        boolean isWeldArchive = false;
        if (this.isEntryPresent(archive, WEB_INF) && !(isWeldArchive = this.isEntryPresent(archive, WEB_INF_BEANS_XML)) && this.isEntryPresent(archive, WEB_INF_LIB)) {
            isWeldArchive = this.scanLibDir(archive, WEB_INF_LIB);
        }
        String archiveName = archive.getName();
        if (!isWeldArchive && archiveName != null && archiveName.endsWith(EXPANDED_JAR_SUFFIX)) {
            isWeldArchive = this.isEntryPresent(archive, META_INF_BEANS_XML);
        }
        if (!isWeldArchive && this.isEntryPresent(archive, META_INF_BEANS_XML)) {
            isWeldArchive = true;
        }
        return isWeldArchive;
    }

    private boolean scanLibDir(ReadableArchive archive, String libLocation) {
        boolean entryPresent = false;
        if (libLocation != null && !libLocation.isEmpty()) {
            Enumeration entries = archive.entries(libLocation);
            while (entries.hasMoreElements() && !entryPresent) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(JAR_SUFFIX) || entryName.indexOf(SEPARATOR_CHAR, libLocation.length() + 1) != -1) continue;
                try {
                    ReadableArchive jarInLib = archive.getSubArchive(entryName);
                    entryPresent = this.isEntryPresent(jarInLib, META_INF_BEANS_XML);
                    jarInLib.close();
                }
                catch (IOException e) {}
            }
        }
        return entryPresent;
    }

    private boolean isEntryPresent(ReadableArchive archive, String entry) {
        boolean entryPresent = false;
        try {
            entryPresent = archive.exists(entry);
        }
        catch (IOException e) {
            // empty catch block
        }
        return entryPresent;
    }

    public String[] getContainersNames() {
        return containers;
    }
}

