/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.node.AddressingNode;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.RespectBindingNode;
import com.sun.enterprise.deployment.node.WebServiceHandlerChainNode;
import com.sun.enterprise.deployment.node.WebServiceHandlerNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebServiceEndpointNode
extends DisplayableComponentNode {
    private static final XMLElement tag = new XMLElement("port-component");

    public WebServiceEndpointNode() {
        this.registerElementHandler(new XMLElement("handler"), WebServiceHandlerNode.class, "addHandler");
        this.registerElementHandler(new XMLElement("addressing"), AddressingNode.class, "setAddressing");
        this.registerElementHandler(new XMLElement("respect-binding"), RespectBindingNode.class, "setRespectBinding");
        this.registerElementHandler(new XMLElement("handler-chain"), WebServiceHandlerChainNode.class, "addHandlerChain");
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("port-component-name", "setEndpointName");
        table.put("service-endpoint-interface", "setServiceEndpointInterface");
        table.put("protocol-binding", "setProtocolBinding");
        table.put("enable-mtom", "setMtomEnabled");
        table.put("mtom-threshold", "setMtomThreshold");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        String elementName = element.getQName();
        WebServiceEndpoint endpoint = (WebServiceEndpoint)this.getDescriptor();
        if ("ejb-link".equals(elementName)) {
            endpoint.setEjbLink(value);
        } else if ("servlet-link".equals(elementName)) {
            endpoint.setWebComponentLink(value);
        } else if ("wsdl-port".equals(elementName)) {
            String prefix = this.getPrefixFromQName(value);
            String localPart = this.getLocalPartFromQName(value);
            String namespaceUri = this.resolvePrefix(element, prefix);
            if (namespaceUri == null) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{prefix, value});
            } else {
                QName wsdlPort = new QName(namespaceUri, localPart);
                endpoint.setWsdlPort(wsdlPort, prefix);
            }
        } else if ("wsdl-service".equals(elementName)) {
            String prefix = this.getPrefixFromQName(value);
            String localPart = this.getLocalPartFromQName(value);
            String namespaceUri = this.resolvePrefix(element, prefix);
            if (namespaceUri == null) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{prefix, value});
            } else {
                QName wsdlSvc = new QName(namespaceUri, localPart);
                endpoint.setWsdlService(wsdlSvc, prefix);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, WebServiceEndpoint descriptor) {
        Element linkNode;
        QName wsdlPort;
        Node wseNode = super.writeDescriptor(parent, nodeName, descriptor);
        this.writeDisplayableComponentInfo(wseNode, descriptor);
        WebServiceEndpointNode.appendTextChild(wseNode, "port-component-name", descriptor.getEndpointName());
        QName wsdlService = descriptor.getWsdlService();
        if (wsdlService != null && wsdlService.getLocalPart().length() != 0) {
            this.appendQNameChild("wsdl-service", wseNode, wsdlService.getNamespaceURI(), wsdlService.getLocalPart(), descriptor.getWsdlServiceNamespacePrefix());
        }
        if ((wsdlPort = descriptor.getWsdlPort()) != null && wsdlPort.getLocalPart().length() != 0) {
            this.appendQNameChild("wsdl-port", wseNode, wsdlPort.getNamespaceURI(), wsdlPort.getLocalPart(), descriptor.getWsdlPortNamespacePrefix());
        }
        WebServiceEndpointNode.appendTextChild(wseNode, "enable-mtom", descriptor.getMtomEnabled());
        WebServiceEndpointNode.appendTextChild(wseNode, "mtom-threshold", descriptor.getMtomThreshold());
        if (descriptor.hasUserSpecifiedProtocolBinding()) {
            WebServiceEndpointNode.appendTextChild(wseNode, "protocol-binding", descriptor.getProtocolBinding());
        }
        WebServiceEndpointNode.appendTextChild(wseNode, "service-endpoint-interface", descriptor.getServiceEndpointInterface());
        if (descriptor.implementedByWebComponent()) {
            linkNode = WebServiceEndpointNode.appendChild(wseNode, "service-impl-bean");
            WebServiceEndpointNode.appendTextChild((Node)linkNode, "servlet-link", descriptor.getWebComponentLink());
        } else if (descriptor.implementedByEjbComponent()) {
            linkNode = WebServiceEndpointNode.appendChild(wseNode, "service-impl-bean");
            WebServiceEndpointNode.appendTextChild((Node)linkNode, "ejb-link", descriptor.getEjbLink());
        } else {
            DOLUtils.getDefaultLogger().log(Level.INFO, "Warning : Web service endpoint " + descriptor.getEndpointName() + " is not tied to a component");
        }
        WebServiceHandlerNode handlerNode = new WebServiceHandlerNode();
        handlerNode.writeWebServiceHandlers(wseNode, descriptor.getHandlers());
        WebServiceHandlerChainNode handlerChainNode = new WebServiceHandlerChainNode();
        handlerChainNode.writeWebServiceHandlerChains(wseNode, descriptor.getHandlerChain());
        return wseNode;
    }
}

