/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataListener;
import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableCursorListener;
import com.sun.data.provider.TableCursorVetoException;
import com.sun.data.provider.TableDataListener;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.AbstractDataProvider;
import com.sun.data.provider.impl.IndexRowKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;

public abstract class AbstractTableDataProvider
extends AbstractDataProvider
implements TableDataProvider {
    private transient ResourceBundle bundle = null;
    protected ArrayList rowKeyList = new ArrayList();
    protected HashMap rowKeyMap = new HashMap();
    protected RowKey cursorRow = new IndexRowKey(0);
    protected TableCursorListener[] tcListeners = null;

    public abstract Class getType(FieldKey var1) throws DataProviderException;

    public abstract boolean isReadOnly(FieldKey var1) throws DataProviderException;

    public abstract int getRowCount() throws DataProviderException;

    public abstract Object getValue(FieldKey var1, RowKey var2) throws DataProviderException;

    public abstract void setValue(FieldKey var1, RowKey var2, Object var3) throws DataProviderException;

    public abstract boolean canInsertRow(RowKey var1) throws DataProviderException;

    public abstract RowKey insertRow(RowKey var1) throws DataProviderException;

    public abstract boolean canAppendRow() throws DataProviderException;

    public abstract RowKey appendRow() throws DataProviderException;

    public abstract boolean canRemoveRow(RowKey var1) throws DataProviderException;

    public abstract void removeRow(RowKey var1) throws DataProviderException;

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com/sun/data/provider/impl/Bundle");
        }
        return this.bundle;
    }

    public RowKey[] getRowKeys(int count, RowKey afterRow) throws DataProviderException {
        int startIndex = 0;
        if (afterRow instanceof IndexRowKey) {
            startIndex = ((IndexRowKey)afterRow).getIndex() + 1;
        }
        int sz = count;
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            sz = count > rowCount - startIndex ? rowCount - startIndex : count;
        }
        RowKey[] rkeys = new RowKey[rowCount == -1 ? 0 : sz];
        for (int i = 0; i < rkeys.length; ++i) {
            rkeys[i] = new IndexRowKey(startIndex + i);
        }
        return rkeys;
    }

    public RowKey getRowKey(String rowId) throws DataProviderException {
        return IndexRowKey.create(rowId);
    }

    public boolean isRowAvailable(RowKey row) throws DataProviderException {
        if (row instanceof IndexRowKey) {
            return this.getRowCount() > ((IndexRowKey)row).getIndex();
        }
        return false;
    }

    public Object getValue(String fieldId, RowKey row) throws DataProviderException {
        return this.getValue(this.getFieldKey(fieldId), row);
    }

    public void setValue(String fieldId, RowKey row, Object value) throws DataProviderException {
        this.setValue(this.getFieldKey(fieldId), row, value);
    }

    public RowKey findFirst(String fieldId, Object value) throws DataProviderException {
        return this.findFirst(this.getFieldKey(fieldId), value);
    }

    public RowKey findFirst(String[] fieldIds, Object[] values) throws DataProviderException {
        FieldKey[] fieldKeys = new FieldKey[fieldIds.length];
        for (int i = 0; i < fieldIds.length; ++i) {
            fieldKeys[i] = this.getFieldKey(fieldIds[i]);
        }
        return this.findFirst(fieldKeys, values);
    }

    public RowKey[] findAll(String fieldId, Object value) throws DataProviderException {
        return this.findAll(this.getFieldKey(fieldId), value);
    }

    public RowKey[] findAll(String[] fieldIds, Object[] values) throws DataProviderException {
        FieldKey[] fieldKeys = new FieldKey[fieldIds.length];
        for (int i = 0; i < fieldIds.length; ++i) {
            fieldKeys[i] = this.getFieldKey(fieldIds[i]);
        }
        return this.findAll(fieldKeys, values);
    }

    public RowKey[] getAllRows() throws DataProviderException {
        RowKey[] rowKeys = null;
        int rowCount = this.getRowCount();
        if (rowCount == -1) {
            int index = 0;
            while ((rowKeys = this.getRowKeys(rowCount = 1000000 * ++index, null)) != null && rowKeys.length - 1 == rowCount) {
            }
        } else {
            rowKeys = this.getRowKeys(rowCount, null);
        }
        return rowKeys;
    }

    public RowKey findFirst(FieldKey fieldKey, Object value) throws DataProviderException {
        RowKey[] rows = this.getRowKeys(10, null);
        do {
            for (int i = 0; i < rows.length; ++i) {
                Object o = this.getValue(fieldKey, rows[i]);
                if (o != value && (o == null || !o.equals(value))) continue;
                return rows[i];
            }
        } while ((rows = this.getRowKeys(10, rows[rows.length - 1])).length > 0);
        return null;
    }

    public RowKey findFirst(FieldKey[] fieldKeys, Object[] values) throws DataProviderException {
        RowKey[] rows = this.getRowKeys(10, null);
        do {
            for (int i = 0; i < rows.length; ++i) {
                boolean match = false;
                for (int j = 0; j < fieldKeys.length; ++j) {
                    Object o = this.getValue(fieldKeys[j], rows[i]);
                    boolean bl = match = o == values[j] || o != null && o.equals(values[j]);
                    if (!match) break;
                }
                if (!match) continue;
                return rows[i];
            }
        } while ((rows = this.getRowKeys(10, rows[rows.length - 1])).length > 0);
        return null;
    }

    public RowKey[] findAll(FieldKey fieldKey, Object value) throws DataProviderException {
        RowKey[] rows = this.getAllRows();
        ArrayList<RowKey> matches = new ArrayList<RowKey>();
        for (int i = 0; i < rows.length; ++i) {
            Object o = this.getValue(fieldKey, rows[i]);
            if (o != value && (o == null || !o.equals(value))) continue;
            matches.add(rows[i]);
        }
        return matches.toArray(new RowKey[matches.size()]);
    }

    public RowKey[] findAll(FieldKey[] fieldKeys, Object[] values) throws DataProviderException {
        RowKey[] rows = this.getAllRows();
        ArrayList<RowKey> matches = new ArrayList<RowKey>();
        for (int i = 0; i < rows.length; ++i) {
            boolean match = false;
            for (int j = 0; j < fieldKeys.length; ++j) {
                Object o = this.getValue(fieldKeys[j], rows[i]);
                boolean bl = match = o == values[j] || o != null && o.equals(values[j]);
                if (!match) break;
            }
            if (!match) continue;
            matches.add(rows[i]);
        }
        return matches.toArray(new RowKey[matches.size()]);
    }

    protected int getCursorIndex() {
        if (this.cursorRow instanceof IndexRowKey) {
            return ((IndexRowKey)this.cursorRow).getIndex();
        }
        return -1;
    }

    protected boolean setCursorIndex(int index) {
        try {
            this.setCursorRow(new IndexRowKey(index));
            return true;
        }
        catch (TableCursorVetoException tcvx) {
            return false;
        }
    }

    public RowKey getCursorRow() throws DataProviderException {
        return this.cursorRow;
    }

    public void setCursorRow(RowKey row) throws TableCursorVetoException {
        if (!this.isRowAvailable(row)) {
            throw new IllegalArgumentException(this.getBundle().getString("ROW_NOT_AVAILABLE"));
        }
        RowKey oldRow = this.cursorRow;
        this.fireCursorChanging(oldRow, row);
        this.cursorRow = row;
        this.fireCursorChanged(oldRow, this.cursorRow);
    }

    public boolean cursorFirst() throws DataProviderException {
        try {
            return this.setCursorIndex(0);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean cursorPrevious() throws DataProviderException {
        try {
            return this.setCursorIndex(this.getCursorIndex() - 1);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean cursorNext() throws DataProviderException {
        try {
            return this.setCursorIndex(this.getCursorIndex() + 1);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean cursorLast() throws DataProviderException {
        try {
            return this.setCursorIndex(this.getRowCount() - 1);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Object getValue(FieldKey fieldKey) throws DataProviderException {
        return this.getValue(fieldKey, this.getCursorRow());
    }

    public void setValue(FieldKey fieldKey, Object value) throws DataProviderException {
        this.setValue(fieldKey, this.getCursorRow(), value);
    }

    public void addTableDataListener(TableDataListener l) {
        super.addDataListener(l);
    }

    public void removeTableDataListener(TableDataListener l) {
        super.removeDataListener(l);
    }

    public TableDataListener[] getTableDataListeners() {
        if (this.dpListeners == null) {
            return new TableDataListener[0];
        }
        ArrayList<DataListener> tdpList = new ArrayList<DataListener>();
        for (int i = 0; i < this.dpListeners.length; ++i) {
            if (!(this.dpListeners[i] instanceof TableDataListener)) continue;
            tdpList.add(this.dpListeners[i]);
        }
        return tdpList.toArray(new TableDataListener[tdpList.size()]);
    }

    public void addTableCursorListener(TableCursorListener listener) {
        if (this.tcListeners == null) {
            this.tcListeners = new TableCursorListener[1];
            this.tcListeners[0] = listener;
            return;
        }
        TableCursorListener[] results = new TableCursorListener[this.tcListeners.length + 1];
        System.arraycopy(this.tcListeners, 0, results, 0, this.tcListeners.length);
        results[results.length - 1] = listener;
        this.tcListeners = results;
    }

    public void removeTableCursorListener(TableCursorListener listener) {
        if (this.tcListeners == null) {
            return;
        }
        ArrayList<TableCursorListener> list = new ArrayList<TableCursorListener>(this.tcListeners.length);
        for (int i = 0; i < this.tcListeners.length; ++i) {
            if (this.tcListeners[i] == listener) continue;
            list.add(this.tcListeners[i]);
        }
        this.tcListeners = list.toArray(new TableCursorListener[list.size()]);
    }

    public TableCursorListener[] getTableCursorListeners() {
        if (this.tcListeners == null) {
            return new TableCursorListener[0];
        }
        return this.tcListeners;
    }

    protected void fireValueChanged(FieldKey fieldKey, RowKey row, Object oldValue, Object newValue) {
        TableDataListener[] tdls = this.getTableDataListeners();
        for (int i = 0; i < tdls.length; ++i) {
            tdls[i].valueChanged(this, fieldKey, row, oldValue, newValue);
        }
    }

    protected void fireRowAdded(RowKey newRow) {
        TableDataListener[] tdls = this.getTableDataListeners();
        for (int i = 0; i < tdls.length; ++i) {
            tdls[i].rowAdded(this, newRow);
        }
    }

    protected void fireRowRemoved(RowKey oldRow) {
        TableDataListener[] tdls = this.getTableDataListeners();
        for (int i = 0; i < tdls.length; ++i) {
            tdls[i].rowRemoved(this, oldRow);
        }
    }

    protected void fireCursorChanging(RowKey oldRow, RowKey newRow) throws TableCursorVetoException {
        TableCursorListener[] tcls = this.getTableCursorListeners();
        for (int i = 0; i < tcls.length; ++i) {
            tcls[i].cursorChanging(this, oldRow, newRow);
        }
    }

    protected void fireCursorChanged(RowKey oldRow, RowKey newRow) {
        TableCursorListener[] tcls = this.getTableCursorListeners();
        for (int i = 0; i < tcls.length; ++i) {
            tcls[i].cursorChanged(this, oldRow, newRow);
        }
    }
}

