/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.single;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.single.ManifestProxy;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyModuleDefinition
implements ModuleDefinition {
    private final ModuleMetadata metadata = new ModuleMetadata();
    private final Manifest manifest;
    private static final String[] EMPTY_STRING_ARRAY;
    private static final ModuleDependency[] EMPTY_MODULE_DEFINITIONS_ARRAY;
    private static URI[] uris;

    public ProxyModuleDefinition(ClassLoader classLoader) throws IOException {
        this(classLoader, null, Collections.singleton("default"));
    }

    public ProxyModuleDefinition(ClassLoader classLoader, List<ManifestProxy.SeparatorMappings> mappings) throws IOException {
        this(classLoader, null, Collections.singleton("default"));
    }

    public ProxyModuleDefinition(ClassLoader classLoader, List<ManifestProxy.SeparatorMappings> mappings, Collection<String> habitatNames) throws IOException {
        this.manifest = new ManifestProxy(classLoader, mappings);
        for (String habitatName : habitatNames) {
            Enumeration<URL> inhabitants = classLoader.getResources("META-INF/inhabitants/" + habitatName);
            while (inhabitants.hasMoreElements()) {
                URL url = inhabitants.nextElement();
                this.metadata.addHabitat(habitatName, new ModuleMetadata.InhabitantsDescriptor(url, ProxyModuleDefinition.readFully(url)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readFully(URL url) throws IOException {
        try {
            URLConnection con = url.openConnection();
            int len = con.getContentLength();
            InputStream in = con.getInputStream();
            try {
                if (len < 0) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    while (true) {
                        int sz;
                        if ((sz = in.read(buf)) < 0) {
                            byte[] byArray = baos.toByteArray();
                            return byArray;
                        }
                        baos.write(buf, 0, sz);
                    }
                }
                byte[] r = new byte[len];
                new DataInputStream(in).readFully(r);
                byte[] byArray = r;
                return byArray;
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            IOException x = new IOException("Failed to read " + url);
            x.initCause(e);
            throw x;
        }
    }

    @Override
    public String getName() {
        return "Static Module";
    }

    @Override
    public String[] getPublicInterfaces() {
        return new String[0];
    }

    @Override
    public ModuleDependency[] getDependencies() {
        return EMPTY_MODULE_DEFINITIONS_ARRAY;
    }

    @Override
    public URI[] getLocations() {
        return uris;
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public String getImportPolicyClassName() {
        return null;
    }

    @Override
    public String getLifecyclePolicyClassName() {
        return null;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public ModuleMetadata getMetadata() {
        return this.metadata;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static boolean ok(String[] ss) {
        return ss != null && ss.length > 0;
    }

    static {
        String[] paths;
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_MODULE_DEFINITIONS_ARRAY = new ModuleDependency[0];
        uris = new URI[0];
        String cp = System.getProperty("java.class.path");
        if (ProxyModuleDefinition.ok(cp) && ProxyModuleDefinition.ok(paths = cp.split(System.getProperty("path.separator")))) {
            uris = new URI[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                ProxyModuleDefinition.uris[i] = new File(paths[i]).toURI();
            }
        }
    }
}

