/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import org.glassfish.appclient.server.core.jws.CombinedXPath;
import org.glassfish.appclient.server.core.jws.DeveloperContentService;
import org.glassfish.appclient.server.core.jws.XPathToDeveloperProvidedContentRefs;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.appclient.server.core.jws.servedcontent.TokenHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class DeveloperContentHandler {
    @Inject
    DeveloperContentService dcs;
    private ClassLoader loader;
    private Map<String, StaticContent> staticContent;
    private Map<String, DynamicContent> dynamicContent;
    private TokenHelper tHelper;
    private File appRootDir;
    private URI appRootURI;
    private LSSerializer lsSerializer = null;
    private LSOutput lsOutput = null;
    private static DocumentBuilderFactory dbf = DeveloperContentHandler.documentBuilderFactory();
    private static DocumentBuilder db = DeveloperContentHandler.documentBuilder();
    private Document developerDOM = null;
    private boolean noDeveloperDOM = false;
    private String jnlpDoc;

    public void init(ClassLoader loader, TokenHelper tHelper, File appRootDir, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, String jnlpDoc) {
        this.loader = loader;
        this.tHelper = tHelper;
        this.appRootDir = appRootDir;
        this.appRootURI = appRootDir.toURI();
        this.staticContent = staticContent;
        this.dynamicContent = dynamicContent;
        this.jnlpDoc = jnlpDoc;
    }

    String combineJNLP(String generatedJNLPTemplate) {
        Document devDOM;
        try {
            devDOM = this.developerDOM();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (devDOM == null) {
            return generatedJNLPTemplate;
        }
        InputSource generatedJNLPSource = new InputSource(new StringReader(generatedJNLPTemplate));
        try {
            Document generatedJNLPDOM = db.parse(generatedJNLPSource);
            for (CombinedXPath combinedXPath : this.dcs.xPathsToCombinedContent()) {
                combinedXPath.process(devDOM, generatedJNLPDOM);
            }
            return this.toXML(devDOM);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private synchronized Document developerDOM() throws ParserConfigurationException, SAXException, IOException {
        Document result = null;
        if (!this.noDeveloperDOM) {
            if (this.jnlpDoc == null) {
                this.noDeveloperDOM = true;
            } else {
                result = this.developerDOM(this.jnlpDoc);
            }
        }
        return result;
    }

    private synchronized Document developerDOM(String devJNLPDoc) throws SAXException, IOException {
        InputStream devJNLPStream;
        Document result = null;
        if (devJNLPDoc != null && (devJNLPStream = this.loader.getResourceAsStream(devJNLPDoc)) != null) {
            result = db.parse(devJNLPStream);
        }
        return result;
    }

    private String toXML(Document dom) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        StringWriter writer = new StringWriter();
        this.writeXML(dom, writer);
        return ((Object)writer).toString();
    }

    private synchronized void writeXML(Node node, Writer writer) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.lsSerializer == null) {
            DOMImplementation domImpl = DOMImplementationRegistry.newInstance().getDOMImplementation("");
            DOMImplementationLS domLS = (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
            this.lsOutput = domLS.createLSOutput();
            this.lsOutput.setEncoding("UTF-8");
            this.lsSerializer = domLS.createLSSerializer();
        }
        this.lsOutput.setCharacterStream(writer);
        this.lsSerializer.write(node, this.lsOutput);
    }

    void addDeveloperContent(String devJNLPDoc) {
        if (devJNLPDoc == null || devJNLPDoc.length() == 0) {
            return;
        }
        try {
            URI codebaseURI = new URI(this.tHelper.appCodebasePath());
            Document devDOM = this.developerDOM(devJNLPDoc);
            for (XPathToDeveloperProvidedContentRefs c : this.dcs.xPathsToDevContentRefs()) {
                NodeList nodes = (NodeList)c.xPathExpr().evaluate(devDOM, XPathConstants.NODESET);
                if (nodes.getLength() <= 0) continue;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String href = nodes.item(i).getNodeValue();
                    c.addToContentIfInApp(this, devJNLPDoc, codebaseURI, href, this.loader, this.staticContent, this.dynamicContent, this.appRootURI);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static DocumentBuilderFactory documentBuilderFactory() {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        try {
            f.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        return f;
    }

    private static DocumentBuilder documentBuilder() {
        try {
            DocumentBuilder b = dbf.newDocumentBuilder();
            return b;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

