/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.module.bootstrap.ArgumentManager;
import com.sun.enterprise.module.bootstrap.PlatformMain;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASMain {
    static final Logger logger = Logger.getAnonymousLogger();
    private static final String PLATFORM_PROPERTY_KEY = "GlassFish_Platform";
    private static final String GF_KERNEL = "org.glassfish.core.kernel";

    public static void main(String[] args) {
        PlatformMain delegate;
        int minor = ASMain.getMinorJdkVersion();
        if (minor < 6) {
            logger.severe("GlassFish requires JDK 6, you are using JDK version " + minor);
            System.exit(1);
        }
        ASMain.setStartupContextProperties(args);
        String platform = Platform.Felix.toString();
        String temp = System.getProperty(PLATFORM_PROPERTY_KEY);
        if (temp == null || temp.trim().length() <= 0) {
            temp = System.getenv(PLATFORM_PROPERTY_KEY);
        }
        if (temp != null && temp.trim().length() != 0) {
            platform = temp.trim();
        }
        if ((delegate = ASMain.getMain(platform)) != null) {
            logger.info("Launching GlassFish on " + platform + " platform");
            System.setProperty(PLATFORM_PROPERTY_KEY, platform);
            try {
                delegate.setLogger(logger);
                delegate.start(args);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            logger.severe("Cannot launch GlassFish on the unkown " + platform + " platform");
        }
    }

    private static PlatformMain getMain(String platform) {
        ServiceLoader<PlatformMain> loader = ServiceLoader.load(PlatformMain.class, ASMain.class.getClassLoader());
        for (PlatformMain main : loader) {
            if (!main.getName().equalsIgnoreCase(platform)) continue;
            return main;
        }
        return null;
    }

    private static void setStartupContextProperties(String ... args) {
        Properties p = ArgumentManager.argsToMap(args);
        p.put("__time_zero", new Long(System.currentTimeMillis()).toString());
        p.put("hk2.startup.context.mainModule", GF_KERNEL);
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-upgrade") || i + 1 >= args.length || args[i + 1].equals("false")) continue;
            p.put("hk2.startup.context.moduleStartup", "upgrade");
        }
        ASMain.addRawStartupInfo(args, p);
        try {
            StringWriter writer = new StringWriter();
            p.store(writer, null);
            System.setProperty("hk2.startup.context.args", ((Object)writer).toString());
        }
        catch (IOException e) {
            logger.info("Could not save startup parameters, will start with none");
            System.setProperty("hk2.startup.context.args", "");
        }
    }

    private static void addRawStartupInfo(String[] args, Properties p) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",,,");
            }
            sb.append(args[i]);
        }
        if (!ASMain.wasStartedByCLI(p)) {
            p.put("-startup-classpath", System.getProperty("java.class.path"));
            p.put("-startup-classname", ASMain.class.getName());
            p.put("-startup-args", sb.toString());
        }
    }

    private static boolean wasStartedByCLI(Properties props) {
        return props.getProperty("-asadmin-classpath") != null && props.getProperty("-asadmin-classname") != null && props.getProperty("-asadmin-args") != null;
    }

    private static int getMinorJdkVersion() {
        try {
            String jv = System.getProperty("java.version");
            String[] ss = jv.split("\\.");
            if (ss == null || ss.length < 3 || !ss[0].equals("1")) {
                return 1;
            }
            return Integer.parseInt(ss[1]);
        }
        catch (Exception e) {
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Platform {
        Felix,
        Knopflerfish,
        Equinox,
        Static;

    }
}

