/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RAWriterAdapter
extends Writer {
    private Logger logger;
    private boolean autoFlush = true;
    private StringBuffer log;

    public RAWriterAdapter(Logger logger) {
        this.logger = logger;
        this.initializeAutoFlush();
    }

    private void initializeAutoFlush() {
        String autoFlushValue = System.getProperty("com.sun.enterprise.connectors.LogWriterAutoFlush", "true");
        this.autoFlush = Boolean.valueOf(autoFlushValue);
    }

    public void write(char[] cbuf, int off, int len) {
        if (this.autoFlush) {
            this.logger.log(Level.INFO, new String(cbuf, off, len));
        } else {
            String s = new String(cbuf, off, len);
            this.log = this.log == null ? new StringBuffer(s) : this.log.append(s);
        }
    }

    public void flush() {
        if (!this.autoFlush) {
            this.logger.log(Level.INFO, this.log.toString());
            this.log = null;
        }
    }

    public void close() {
    }
}

