/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.container;

import com.sun.jersey.api.Responses;
import com.sun.jersey.api.container.MappableContainerException;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.api.core.TraceInformation;
import com.sun.jersey.core.header.OutBoundHeaders;
import com.sun.jersey.core.reflection.ReflectionHelper;
import com.sun.jersey.core.spi.factory.ResponseBuilderHeaders;
import com.sun.jersey.core.spi.factory.ResponseImpl;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.WebApplication;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerResponse
implements HttpResponseContext {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final Logger LOGGER = Logger.getLogger(ContainerResponse.class.getName());
    private static final RuntimeDelegate rd = RuntimeDelegate.getInstance();
    private final WebApplication wa;
    private ContainerRequest request;
    private ContainerResponseWriter responseWriter;
    private Response response;
    private Throwable mappedThrowable;
    private int status;
    private MultivaluedMap<String, Object> headers;
    private Object originalEntity;
    private Object entity;
    private Type entityType;
    private boolean isCommitted;
    private CommittingOutputStream out;
    private Annotation[] annotations = EMPTY_ANNOTATIONS;

    public ContainerResponse(WebApplication wa, ContainerRequest request, ContainerResponseWriter responseWriter) {
        this.wa = wa;
        this.request = request;
        this.responseWriter = responseWriter;
        this.status = 204;
    }

    ContainerResponse(ContainerResponse acr) {
        this.wa = acr.wa;
    }

    public static String getHeaderValue(Object headerValue) {
        RuntimeDelegate.HeaderDelegate hp = rd.createHeaderDelegate(headerValue.getClass());
        return hp != null ? hp.toString(headerValue) : headerValue.toString();
    }

    public void write() throws IOException {
        MessageBodyWriter<?> p;
        if (this.isCommitted) {
            return;
        }
        if (this.request.isTracingEnabled()) {
            this.configureTrace(this.responseWriter);
        }
        if (this.entity == null) {
            this.isCommitted = true;
            this.responseWriter.writeStatusAndHeaders(-1L, this);
            this.responseWriter.finish();
            return;
        }
        MediaType contentType = this.getMediaType();
        if (contentType == null) {
            contentType = this.getMessageBodyWorkers().getMessageBodyWriterMediaType(this.entity.getClass(), this.entityType, this.annotations, this.request.getAcceptableMediaTypes());
            if (contentType == null || contentType.isWildcardType() || contentType.isWildcardSubtype()) {
                contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
            this.getHttpHeaders().putSingle((Object)"Content-Type", (Object)contentType);
        }
        if ((p = this.getMessageBodyWorkers().getMessageBodyWriter(this.entity.getClass(), this.entityType, this.annotations, contentType)) == null) {
            LOGGER.severe("A message body writer for Java type, " + this.entity.getClass() + ", and MIME media type, " + contentType + ", was not found");
            if (this.request.getMethod().equals("HEAD")) {
                this.isCommitted = true;
                this.responseWriter.writeStatusAndHeaders(-1L, this);
                this.responseWriter.finish();
                return;
            }
            throw new WebApplicationException(500);
        }
        long size = p.getSize(this.entity, this.entity.getClass(), this.entityType, this.annotations, contentType);
        if (this.request.getMethod().equals("HEAD")) {
            if (size != -1L) {
                this.getHttpHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(size));
            }
            this.isCommitted = true;
            this.responseWriter.writeStatusAndHeaders(0L, this);
        } else {
            if (this.request.isTracingEnabled()) {
                this.request.trace(String.format("matched message body writer: %s, \"%s\" -> %s", ReflectionHelper.objectToString(this.entity), contentType, ReflectionHelper.objectToString(p)));
            }
            if (this.out == null) {
                this.out = new CommittingOutputStream(size);
            }
            p.writeTo(this.entity, this.entity.getClass(), this.entityType, this.annotations, contentType, this.getHttpHeaders(), (OutputStream)this.out);
            if (!this.isCommitted) {
                this.isCommitted = true;
                this.responseWriter.writeStatusAndHeaders(-1L, this);
            }
        }
        this.responseWriter.finish();
    }

    private void configureTrace(final ContainerResponseWriter crw) {
        final TraceInformation ti = (TraceInformation)this.request.getProperties().get(TraceInformation.class.getName());
        this.setContainerResponseWriter(new ContainerResponseWriter(){

            public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse response) throws IOException {
                ti.addTraceHeaders();
                return crw.writeStatusAndHeaders(contentLength, response);
            }

            public void finish() throws IOException {
                crw.finish();
            }
        });
    }

    public void reset() {
        this.setResponse(Responses.noContent().build());
    }

    public ContainerRequest getContainerRequest() {
        return this.request;
    }

    public void setContainerRequest(ContainerRequest request) {
        this.request = request;
    }

    public ContainerResponseWriter getContainerResponseWriter() {
        return this.responseWriter;
    }

    public void setContainerResponseWriter(ContainerResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    public MessageBodyWorkers getMessageBodyWorkers() {
        return this.wa.getMessageBodyWorkers();
    }

    public void mapMappableContainerException(MappableContainerException e) {
        Throwable cause = e.getCause();
        if (cause instanceof WebApplicationException) {
            this.mapWebApplicationException((WebApplicationException)cause);
        } else if (!this.mapException(cause)) {
            if (cause instanceof RuntimeException) {
                LOGGER.log(Level.SEVERE, "The RuntimeException could not be mapped to a response, re-throwing to the HTTP container", cause);
                throw (RuntimeException)cause;
            }
            LOGGER.log(Level.SEVERE, "The exception contained within MappableContainerException could not be mapped to a response, re-throwing to the HTTP container", cause);
            throw e;
        }
    }

    public void mapWebApplicationException(WebApplicationException e) {
        if (e.getResponse().getEntity() != null) {
            this.onException(e, e.getResponse(), false);
        } else if (!this.mapException(e)) {
            this.onException(e, e.getResponse(), false);
        }
    }

    public boolean mapException(Throwable e) {
        ExceptionMapper em = this.wa.getExceptionMapperContext().find(e.getClass());
        if (em == null) {
            return false;
        }
        if (this.request.isTracingEnabled()) {
            this.request.trace(String.format("matched exception mapper: %s -> %s", ReflectionHelper.objectToString(e), ReflectionHelper.objectToString(em)));
        }
        try {
            Response r = em.toResponse(e);
            if (r == null) {
                r = Response.noContent().build();
            }
            this.onException(e, r, true);
        }
        catch (MappableContainerException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            LOGGER.severe("Exception mapper " + em + " for Throwable " + e + " threw a RuntimeException when " + "attempting to obtain the response");
            Response r = Response.serverError().build();
            this.onException(ex, r, false);
        }
        return true;
    }

    private void onException(Throwable e, Response r, boolean mapped) {
        if (!mapped) {
            if (r.getStatus() >= 500 || this.request.isTracingEnabled()) {
                this.traceException(e, r);
            }
            if (r.getStatus() >= 500 && r.getEntity() == null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                r = Response.status((int)r.getStatus()).entity((Object)sw.toString()).type("text/plain").build();
            }
        } else if (this.request.isTracingEnabled()) {
            this.traceException(e, r);
        }
        this.setResponse(r);
        this.mappedThrowable = e;
    }

    private void traceException(Throwable e, Response r) {
        Level l;
        Response.Status s = Response.Status.fromStatusCode((int)r.getStatus());
        Level level = l = r.getStatus() >= 500 ? Level.SEVERE : Level.INFO;
        if (s != null) {
            LOGGER.log(l, "Mapped exception to response: " + r.getStatus() + " (" + s.getReasonPhrase() + ")", e);
        } else {
            LOGGER.log(l, "Mapped exception to response: " + r.getStatus(), e);
        }
    }

    @Override
    public Response getResponse() {
        if (this.response == null) {
            this.setResponse(null);
        }
        return this.response;
    }

    @Override
    public void setResponse(Response response) {
        this.isCommitted = false;
        this.out = null;
        response = response != null ? response : Responses.noContent().build();
        this.response = response;
        this.mappedThrowable = null;
        this.status = response.getStatus();
        this.headers = response instanceof ResponseImpl ? this.setResponseOptimal((ResponseImpl)response) : this.setResponseNonOptimal(response);
    }

    @Override
    public boolean isResponseSet() {
        return this.response != null;
    }

    @Override
    public Throwable getMappedThrowable() {
        return this.mappedThrowable;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public Type getEntityType() {
        return this.entityType;
    }

    @Override
    public Object getOriginalEntity() {
        return this.originalEntity;
    }

    @Override
    public void setEntity(Object entity) {
        this.originalEntity = this.entity = entity;
        if (this.entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)this.entity;
            this.entityType = ge.getType();
            this.entity = ge.getEntity();
        } else if (entity != null) {
            this.entityType = this.entity.getClass();
        }
        this.checkStatusAndEntity();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations != null ? annotations : EMPTY_ANNOTATIONS;
    }

    @Override
    public MultivaluedMap<String, Object> getHttpHeaders() {
        if (this.headers == null) {
            this.headers = new OutBoundHeaders();
        }
        return this.headers;
    }

    @Override
    public MediaType getMediaType() {
        Object mediaTypeHeader = this.getHttpHeaders().getFirst((Object)"Content-Type");
        if (mediaTypeHeader instanceof MediaType) {
            return (MediaType)mediaTypeHeader;
        }
        if (mediaTypeHeader != null) {
            return MediaType.valueOf((String)mediaTypeHeader.toString());
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new CommittingOutputStream(-1L);
        }
        return this.out;
    }

    @Override
    public boolean isCommitted() {
        return this.isCommitted;
    }

    private void checkStatusAndEntity() {
        if (this.status == 204 && this.entity != null) {
            this.status = 200;
        } else if (this.status == 200 && this.entity == null) {
            this.status = 204;
        }
    }

    private MultivaluedMap<String, Object> setResponseOptimal(ResponseImpl r) {
        if (r.isMetatadataSet()) {
            return this.setResponseNonOptimal(r);
        }
        this.originalEntity = this.entity = r.getEntity();
        this.entityType = r.getEntityType();
        if (this.entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)this.entity;
            this.entityType = ge.getType();
            this.entity = ge.getEntity();
        }
        return this.getMetadataOptimal(r.getValues(), r.getNameValuePairs());
    }

    private MultivaluedMap<String, Object> getMetadataOptimal(Object[] values, List<Object> nameValuePairs) {
        OutBoundHeaders _headers = new OutBoundHeaders();
        for (int i = 0; i < values.length; ++i) {
            URI locationUri;
            if (i != 6) {
                if (values[i] == null) continue;
                _headers.putSingle(ResponseBuilderHeaders.getNameFromId(i), values[i]);
                continue;
            }
            Object location = values[i];
            if (location == null) continue;
            if (location instanceof URI && !(locationUri = (URI)location).isAbsolute()) {
                URI base = this.status == 201 ? this.request.getAbsolutePath() : this.request.getBaseUri();
                location = UriBuilder.fromUri((URI)base).path(locationUri.getRawPath()).replaceQuery(locationUri.getRawQuery()).fragment(locationUri.getRawFragment()).build(new Object[0]);
            }
            _headers.putSingle("Location", location);
        }
        if (nameValuePairs.size() > 0) {
            Iterator<Object> i = nameValuePairs.iterator();
            while (i.hasNext()) {
                _headers.add((String)i.next(), i.next());
            }
        }
        return _headers;
    }

    private MultivaluedMap<String, Object> setResponseNonOptimal(Response r) {
        this.setEntity(r.getEntity());
        MultivaluedMap _headers = r.getMetadata();
        Object location = _headers.getFirst((Object)"Location");
        if (location != null && location instanceof URI) {
            URI locationUri = (URI)location;
            if (!locationUri.isAbsolute()) {
                URI base = this.status == 201 ? this.request.getAbsolutePath() : this.request.getBaseUri();
                location = UriBuilder.fromUri((URI)base).path(locationUri.getRawPath()).replaceQuery(locationUri.getRawQuery()).fragment(locationUri.getRawFragment()).build(new Object[0]);
            }
            _headers.putSingle((Object)"Location", location);
        }
        return _headers;
    }

    private final class CommittingOutputStream
    extends OutputStream {
        private final long size;
        private OutputStream o;

        CommittingOutputStream(long size) {
            this.size = size;
        }

        public void write(byte[] b) throws IOException {
            this.commitWrite();
            this.o.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.commitWrite();
            this.o.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.commitWrite();
            this.o.write(b);
        }

        public void flush() throws IOException {
            this.commitWrite();
            this.o.flush();
        }

        public void close() throws IOException {
            this.commitClose();
            this.o.close();
        }

        private void commitWrite() throws IOException {
            if (!ContainerResponse.this.isCommitted) {
                if (ContainerResponse.this.getStatus() == 204) {
                    ContainerResponse.this.setStatus(200);
                }
                ContainerResponse.this.isCommitted = true;
                this.o = ContainerResponse.this.responseWriter.writeStatusAndHeaders(this.size, ContainerResponse.this);
            }
        }

        private void commitClose() throws IOException {
            if (!ContainerResponse.this.isCommitted) {
                ContainerResponse.this.isCommitted = true;
                this.o = ContainerResponse.this.responseWriter.writeStatusAndHeaders(-1L, ContainerResponse.this);
            }
        }
    }
}

