/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectorTimerProxy
extends Timer {
    private static ConnectorTimerProxy connectorTimer;
    private Timer timer;
    private final Object getTimerLock = new Object();
    private static final Logger _logger;

    private ConnectorTimerProxy(boolean isDaemon) {
        super(isDaemon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer getTimer() {
        Object object = this.getTimerLock;
        synchronized (object) {
            if (this.timer == null) {
                ClassLoader loader = null;
                try {
                    loader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader((ClassLoader)ConnectorRuntime.getRuntime().getConnectorClassLoader());
                    this.timer = new Timer("connector-timer-proxy", true);
                    Object var4_3 = null;
                    Thread.currentThread().setContextClassLoader(loader);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    Thread.currentThread().setContextClassLoader(loader);
                    throw throwable;
                }
            }
        }
        return this.timer;
    }

    public static final ConnectorTimerProxy getProxy() {
        if (connectorTimer == null) {
            connectorTimer = new ConnectorTimerProxy(true);
        }
        return connectorTimer;
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        this.timer = this.getTimer();
        try {
            this.timer.scheduleAtFixedRate(task, delay, period);
        }
        catch (Exception ex) {
            this.handleTimerException(ex);
            this.timer.scheduleAtFixedRate(task, delay, period);
        }
    }

    public void cancel() {
        this.timer = this.getTimer();
        try {
            this.timer.cancel();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "exception_cancelling_timer", ex.getMessage());
        }
    }

    public int purge() {
        int status = 0;
        this.timer = this.getTimer();
        try {
            status = this.timer.purge();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "exception_purging_timer", ex.getMessage());
        }
        return status;
    }

    public void schedule(TimerTask task, long delay) {
        this.timer = this.getTimer();
        try {
            this.timer.schedule(task, delay);
        }
        catch (Exception ex) {
            this.handleTimerException(ex);
            this.timer.schedule(task, delay);
        }
    }

    public void schedule(TimerTask task, Date time) {
        this.timer = this.getTimer();
        try {
            this.timer.schedule(task, time);
        }
        catch (Exception ex) {
            this.handleTimerException(ex);
            this.timer.schedule(task, time);
        }
    }

    public void schedule(TimerTask task, long delay, long period) {
        this.timer = this.getTimer();
        try {
            this.timer.schedule(task, delay, period);
        }
        catch (Exception ex) {
            this.handleTimerException(ex);
            this.timer.schedule(task, delay, period);
        }
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        this.timer = this.getTimer();
        try {
            this.timer.schedule(task, firstTime, period);
        }
        catch (Exception ex) {
            this.handleTimerException(ex);
            this.timer.schedule(task, firstTime, period);
        }
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        this.timer = this.getTimer();
        try {
            this.timer.scheduleAtFixedRate(task, firstTime, period);
        }
        catch (Exception ex) {
            this.handleTimerException(ex);
            this.timer.scheduleAtFixedRate(task, firstTime, period);
        }
    }

    private void handleTimerException(Exception ex) {
        _logger.log(Level.WARNING, "exception_scheduling_timer", ex.getMessage());
        _logger.info("Recreating Timer and scheduling at fixed rate");
        this.timer = null;
        this.timer = this.getTimer();
    }

    static {
        _logger = LogDomains.getLogger(ConnectorTimerProxy.class, (String)"javax.enterprise.resource.resourceadapter");
    }
}

