/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.resizer;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.PoolProperties;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resizer
extends TimerTask {
    private String poolName;
    private DataStructure ds;
    private PoolProperties pool;
    private ResourceHandler handler;
    private boolean preferValidateOverRecreate = false;
    private static final Logger _logger = LogDomains.getLogger(Resizer.class, (String)"javax.enterprise.resource.resourceadapter");

    public Resizer(String poolName, DataStructure ds, PoolProperties pp, ResourceHandler handler, boolean preferValidateOverRecreate) {
        this.poolName = poolName;
        this.ds = ds;
        this.pool = pp;
        this.handler = handler;
        this.preferValidateOverRecreate = preferValidateOverRecreate;
    }

    @Override
    public void run() {
        Resizer.debug("Resizer for pool " + this.poolName);
        try {
            this.resizePool(true);
        }
        catch (Exception ex) {
            Object[] params = new Object[]{this.poolName, ex.getMessage()};
            _logger.log(Level.WARNING, "resource_pool.resize_pool_error", params);
        }
    }

    public void resizePool(boolean forced) {
        if (this.pool.getWaitQueueLength() > 0) {
            return;
        }
        int noOfResourcesRemoved = this.removeIdleAndInvalidResources();
        int poolScaleDownQuantity = this.pool.getResizeQuantity() - noOfResourcesRemoved;
        this.scaleDownPool(poolScaleDownQuantity, forced);
        this.ensureSteadyPool();
        Resizer.debug("No. of resources held for pool [ " + this.poolName + " ] : " + this.ds.getResourcesSize());
    }

    private void ensureSteadyPool() {
        if (this.ds.getResourcesSize() < this.pool.getSteadyPoolSize()) {
            for (int i = this.ds.getResourcesSize(); i < this.pool.getSteadyPoolSize(); ++i) {
                try {
                    this.handler.createResourceAndAddToPool();
                    continue;
                }
                catch (PoolingException ex) {
                    Object[] params = new Object[]{this.poolName, ex.getMessage()};
                    _logger.log(Level.WARNING, "resource_pool.resize_pool_error", params);
                }
            }
        }
    }

    private void scaleDownPool(int scaleDownQuantity, boolean forced) {
        if (this.pool.getResizeQuantity() > 0 && forced) {
            ResourceHandle h;
            int n = scaleDownQuantity = scaleDownQuantity <= this.ds.getResourcesSize() - this.pool.getSteadyPoolSize() ? scaleDownQuantity : 0;
            while (scaleDownQuantity > 0 && (h = this.ds.getResource()) != null) {
                this.ds.removeResource(h);
                --scaleDownQuantity;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeIdleAndInvalidResources() {
        int poolSizeBeforeRemoval = this.ds.getResourcesSize();
        int size = this.ds.getFreeListSize();
        long currentTime = System.currentTimeMillis();
        int validConnectionsCounter = 0;
        int idleConnKeptInSteadyCounter = 0;
        HashSet<ResourceHandle> activeResources = new HashSet<ResourceHandle>();
        HashSet<String> resourcesToValidate = new HashSet<String>();
        try {
            ResourceHandle h;
            while ((h = this.ds.getResource()) != null) {
                ResourceState state = h.getResourceState();
                if (currentTime - state.getTimestamp() > this.pool.getIdleTimeout()) {
                    ResourceAllocator alloc = h.getResourceAllocator();
                    if (this.preferValidateOverRecreate && alloc.hasValidatingMCF()) {
                        if (validConnectionsCounter < this.pool.getSteadyPoolSize() && alloc.isConnectionValid(h)) {
                            ++idleConnKeptInSteadyCounter;
                            Resizer.debug("PreferValidateOverRecreate: Keeping idle resource " + h + " in the steady part of the free pool " + "as the RA reports it to be valid (" + ++validConnectionsCounter + " <= " + this.pool.getSteadyPoolSize() + ")");
                            h.setLastValidated(System.currentTimeMillis());
                            state.touchTimestamp();
                            continue;
                        }
                        if (_logger.isLoggable(Level.FINEST)) {
                            if (validConnectionsCounter <= this.pool.getSteadyPoolSize()) {
                                _logger.log(Level.FINEST, "PreferValidateOverRecreate: Removing idle resource " + h + " from the free pool as the RA reports it to be invalid");
                            } else {
                                _logger.log(Level.FINEST, "PreferValidateOverRecreate: Removing idle resource " + h + " from the free pool as the steady part size has " + "already been exceeded (" + validConnectionsCounter + " > " + this.pool.getSteadyPoolSize() + ")");
                            }
                        }
                        this.ds.removeResource(h);
                        continue;
                    }
                    this.ds.removeResource(h);
                    continue;
                }
                ++validConnectionsCounter;
                resourcesToValidate.add(h.toString());
                activeResources.add(h);
            }
        }
        finally {
            for (ResourceHandle activeResource : activeResources) {
                this.ds.returnResource(activeResource);
            }
        }
        this.removeInvalidResources(resourcesToValidate);
        if (this.preferValidateOverRecreate) {
            Resizer.debug("Idle resources validated and kept in the steady pool for pool [ " + this.poolName + " ] - " + idleConnKeptInSteadyCounter);
            Resizer.debug("Number of Idle resources freed for pool [ " + this.poolName + " ] - " + (size - activeResources.size() - idleConnKeptInSteadyCounter));
            Resizer.debug("Number of Invalid resources removed for pool [ " + this.poolName + " ] - " + (activeResources.size() - this.ds.getFreeListSize() + idleConnKeptInSteadyCounter));
        } else {
            Resizer.debug("Number of Idle resources freed for pool [ " + this.poolName + " ] - " + (size - activeResources.size()));
            Resizer.debug("Number of Invalid resources removed for pool [ " + this.poolName + " ] - " + (activeResources.size() - this.ds.getFreeListSize()));
        }
        int noOfResourcesRemoved = poolSizeBeforeRemoval - this.ds.getResourcesSize();
        return noOfResourcesRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeInvalidResources(Set<String> freeConnectionsToValidate) {
        try {
            Resizer.debug("Sending a set of free connections to RA, of size : " + freeConnectionsToValidate.size());
            int invalidConnectionsCount = 0;
            HashSet<ResourceHandle> validResources = new HashSet<ResourceHandle>();
            try {
                ResourceHandle handle;
                block6: while ((handle = this.ds.getResource()) != null) {
                    if (freeConnectionsToValidate.contains(handle.toString())) {
                        HashSet<Object> connectionsToTest = new HashSet<Object>();
                        connectionsToTest.add(handle.getResource());
                        Set invalidConnections = this.handler.getInvalidConnections(connectionsToTest);
                        if (invalidConnections != null && invalidConnections.size() > 0) {
                            Iterator i$ = invalidConnections.iterator();
                            while (true) {
                                if (!i$.hasNext()) continue block6;
                                Object o = i$.next();
                                ManagedConnection invalidConnection = (ManagedConnection)o;
                                if (!invalidConnection.equals(handle.getResource())) continue;
                                this.ds.removeResource(handle);
                                this.handler.invalidConnectionDetected(handle);
                                ++invalidConnectionsCount;
                            }
                        }
                        validResources.add(handle);
                        continue;
                    }
                    validResources.add(handle);
                }
                return;
            }
            finally {
                Iterator i$ = validResources.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        validResources.clear();
                        Resizer.debug("No. of invalid connections received from RA : " + invalidConnectionsCount);
                    }
                    ResourceHandle resourceHandle = (ResourceHandle)i$.next();
                    this.ds.returnResource(resourceHandle);
                }
            }
        }
        catch (ResourceException re) {
            _logger.log(Level.FINE, "ResourceException while trying to get invalid connections from MCF", re);
            return;
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Exception while trying to get invalid connections from MCF", e);
        }
    }

    private static void debug(String debugStatement) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, debugStatement);
        }
    }
}

