/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.util.Grizzly;
import com.sun.grizzly.util.http.Enumerator;
import com.sun.grizzly.util.http.MimeType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextImpl
implements ServletContext {
    private static final ArrayList empty = new ArrayList();
    private final transient ArrayList<EventListener> eventListeners = new ArrayList();
    private final ConcurrentHashMap<String, String> parameters = new ConcurrentHashMap(16, 0.75f, 64);
    private final ConcurrentHashMap attributes = new ConcurrentHashMap(16, 0.75f, 64);
    private String contextPath = "";
    private final Logger logger = Logger.getLogger("Grizzly");
    private String basePath = "";
    private String contextName = "";

    protected void initListeners(ArrayList<String> listeners) {
        for (String listenerClass : listeners) {
            EventListener el = null;
            try {
                el = (EventListener)Thread.currentThread().getContextClassLoader().loadClass(listenerClass).newInstance();
                this.eventListeners.add(el);
            }
            catch (Throwable e) {
                this.logger.warning("Unable to load listener: " + el);
            }
        }
        ServletContextEvent event = null;
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            if (!(this.eventListeners.get(i) instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)this.eventListeners.get(i);
            if (event == null) {
                event = new ServletContextEvent((ServletContext)this);
            }
            try {
                listener.contextInitialized(event);
                continue;
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "", t);
            }
        }
    }

    protected void destroyListeners() {
        ServletContextEvent event = null;
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            if (!(this.eventListeners.get(i) instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)this.eventListeners.get(i);
            if (event == null) {
                event = new ServletContextEvent((ServletContext)this);
            }
            try {
                listener.contextDestroyed(event);
                continue;
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "", t);
            }
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    protected void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public ServletContext getContext(String uri) {
        return this;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        int period = file.lastIndexOf(".");
        if (period < 0) {
            return null;
        }
        String extension = file.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return MimeType.get((String)extension);
    }

    public Set getResourcePaths(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        File[] files = new File(this.basePath, path).listFiles();
        HashSet<String> list = new HashSet<String>();
        if (files != null) {
            for (File f : files) {
                try {
                    String canonicalPath = f.getCanonicalPath();
                    canonicalPath = canonicalPath.substring(canonicalPath.indexOf(this.basePath) + this.basePath.length());
                    list.add(canonicalPath);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return list;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        if (path.length() > 1) {
            path = path.substring(1);
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        return url;
    }

    public InputStream getResourceAsStream(String path) {
        if ((path = this.normalize(path)) == null) {
            return null;
        }
        if (path.length() > 1) {
            path = path.substring(1);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RequestDispatcher getNamedDispatcher(String arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration getServlets() {
        return new Enumerator((Collection)empty);
    }

    public Enumeration getServletNames() {
        return new Enumerator((Collection)empty);
    }

    public void log(String string) {
        this.logger.log(Level.INFO, string);
    }

    public void log(Exception e, String msg) {
        this.logger.log(Level.INFO, msg, e);
    }

    public void log(String msg, Throwable t) {
        this.logger.log(Level.INFO, msg, t);
    }

    public String getRealPath(String path) {
        if (path == null) {
            return null;
        }
        return new File(this.basePath, path).getAbsolutePath();
    }

    public String getServerInfo() {
        return Grizzly.getServerInfo();
    }

    public String getInitParameter(String name) {
        return this.parameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new Enumerator((Collection)this.parameters.keySet());
    }

    protected void setInitParameter(HashMap<String, String> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new Enumerator((Collection)this.attributes.keySet());
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = this.attributes.put(name, value);
        ServletContextAttributeEvent event = null;
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            if (!(this.eventListeners.get(i) instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)this.eventListeners.get(i);
            try {
                if (event == null) {
                    event = oldValue != null ? new ServletContextAttributeEvent((ServletContext)this, name, oldValue) : new ServletContextAttributeEvent((ServletContext)this, name, value);
                }
                if (oldValue != null) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "", t);
            }
        }
    }

    public void removeAttribute(String name) {
        Object value = this.attributes.remove(name);
        if (value == null) {
            return;
        }
        ServletContextAttributeEvent event = null;
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            if (!(this.eventListeners.get(i) instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)this.eventListeners.get(i);
            try {
                if (event == null) {
                    event = new ServletContextAttributeEvent((ServletContext)this, name, value);
                }
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "", t);
            }
        }
    }

    public String getServletContextName() {
        return this.contextName;
    }

    public void setDisplayName(String contextName) {
        this.contextName = contextName;
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    protected String getBasePath() {
        return this.basePath;
    }

    protected void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    protected List<EventListener> getListeners() {
        return this.eventListeners;
    }
}

